/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.richclient.settings.SettingsException;
import org.springframework.richclient.settings.xml.RootXmlSettings;
import org.springframework.richclient.settings.xml.XmlSettingsReaderWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FileSystemXmlSettingsReaderWriter
implements XmlSettingsReaderWriter {
    private String location;

    public FileSystemXmlSettingsReaderWriter(String location) {
        this.location = location;
    }

    public void write(RootXmlSettings settings) throws SettingsException {
        try {
            File file = this.createFile(settings.getName());
            file.getParentFile().mkdirs();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(settings.getDocument()), new StreamResult(new FileOutputStream(file)));
        }
        catch (TransformerConfigurationException e) {
            throw new SettingsException("Unable to write document", e);
        }
        catch (TransformerException e) {
            throw new SettingsException("Unable to write document", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new SettingsException("Unable to write document", e);
        }
        catch (FileNotFoundException e) {
            throw new SettingsException("Unable to write document", e);
        }
    }

    public RootXmlSettings read(String key) throws SettingsException {
        try {
            File file = this.createFile(key);
            Document doc = null;
            if (file.exists()) {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(file));
            } else {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element element = doc.createElement("settings");
                element.setAttribute("name", key);
                doc.appendChild(element);
            }
            RootXmlSettings settings = new RootXmlSettings(doc, this);
            return settings;
        }
        catch (SAXException e) {
            throw new SettingsException("Unable to read xml", e);
        }
        catch (IOException e) {
            throw new SettingsException("Unable to read xml", e);
        }
        catch (ParserConfigurationException e) {
            throw new SettingsException("Unable to read xml", e);
        }
        catch (FactoryConfigurationError e) {
            throw new SettingsException("Unable to read xml", e);
        }
    }

    private File createFile(String key) {
        return new File(this.location, key + ".settings.xml");
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

