/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.xml;

import java.io.IOException;
import org.springframework.richclient.settings.SettingsException;
import org.springframework.richclient.settings.xml.XmlSettings;
import org.springframework.richclient.settings.xml.XmlSettingsReaderWriter;
import org.springframework.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RootXmlSettings
extends XmlSettings {
    private XmlSettingsReaderWriter readerWriter;
    private Document doc;

    public RootXmlSettings(Document doc, XmlSettingsReaderWriter readerWriter) {
        super(RootXmlSettings.getSettingsElement(doc));
        this.doc = doc;
        Assert.notNull((Object)readerWriter, (String)"XmlSettingsReaderWriter cannot be null");
        this.readerWriter = readerWriter;
    }

    private static Element getSettingsElement(Document doc) {
        Assert.notNull((Object)doc, (String)"Document cannot be null");
        return doc.getDocumentElement();
    }

    public void save() throws IOException {
        try {
            this.readerWriter.write(this);
        }
        catch (SettingsException e) {
            e.printStackTrace();
        }
    }

    public Document getDocument() {
        return this.doc;
    }
}

