/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.xml;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.springframework.richclient.settings.SettingsException;
import org.springframework.richclient.settings.xml.RootXmlSettings;
import org.springframework.richclient.settings.xml.XmlSettingsReaderWriter;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class StringXmlSettingsReaderWriter
implements XmlSettingsReaderWriter {
    private String xml;
    private StringWriter buffer;

    public StringXmlSettingsReaderWriter(String xml) {
        this.xml = xml;
    }

    public StringXmlSettingsReaderWriter() {
        this(null);
    }

    public void write(RootXmlSettings settings) throws SettingsException {
        try {
            this.buffer = new StringWriter();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(settings.getDocument()), new StreamResult(this.buffer));
        }
        catch (Exception e) {
            throw new SettingsException("Unable to write xml", e);
        }
    }

    public String getBuffer() {
        return this.buffer.getBuffer().toString();
    }

    public RootXmlSettings read(String key) throws SettingsException {
        try {
            Document doc = null;
            if (StringUtils.hasText((String)this.xml)) {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(this.xml)));
            } else {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element element = doc.createElement("settings");
                element.setAttribute("name", key);
                doc.appendChild(element);
            }
            return new RootXmlSettings(doc, this);
        }
        catch (Exception e) {
            throw new SettingsException("Unable to parse xml " + this.xml, e);
        }
    }
}

