/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.settings.xml;

import org.springframework.richclient.settings.Settings;
import org.springframework.richclient.settings.SettingsException;
import org.springframework.richclient.settings.SettingsFactory;
import org.springframework.richclient.settings.xml.FileSystemXmlSettingsReaderWriter;
import org.springframework.richclient.settings.xml.XmlSettingsReaderWriter;

public class XmlSettingsFactory
implements SettingsFactory {
    private String location;
    private XmlSettingsReaderWriter readerWriter;

    public XmlSettingsReaderWriter getReaderWriter() {
        if (this.readerWriter == null) {
            this.readerWriter = new FileSystemXmlSettingsReaderWriter(this.getLocation());
        }
        return this.readerWriter;
    }

    public void setReaderWriter(XmlSettingsReaderWriter readerWriter) {
        this.readerWriter = readerWriter;
    }

    public Settings createSettings(String key) throws SettingsException {
        return this.getReaderWriter().read(key);
    }

    public String getLocation() {
        if (this.location == null) {
            this.location = "settings";
        }
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

