/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table.support;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.richclient.application.event.LifecycleApplicationEvent;
import org.springframework.richclient.application.statusbar.StatusBar;
import org.springframework.richclient.command.ActionCommandExecutor;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.GuardedActionCommandExecutor;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.table.support.GlazedTableModel;
import org.springframework.richclient.util.PopupMenuMouseListener;
import org.springframework.util.Assert;

public abstract class AbstractObjectTable
extends AbstractControlFactory
implements ApplicationListener {
    private final String modelId;
    private String objectSingularName;
    private String objectPluralName;
    private Object[] initialData;
    private String[] columnPropertyNames;
    private GlazedTableModel model;
    private SortedList baseList;
    private EventList finalEventList;
    private ActionCommandExecutor doubleClickHandler;
    private CommandGroup popupCommandGroup;
    private StatusBar statusBar;
    private AbstractTableComparatorChooser tableSorter;
    public static final String SHOWINGALL_MSG_KEY = "objectTable.showingAll.message";
    public static final String SHOWINGN_MSG_KEY = "objectTable.showingN.message";
    public static final String SELECTEDN_MSG_KEY = "objectTable.selectedN.message";

    public AbstractObjectTable(String modelId, String[] columnPropertyNames) {
        this.modelId = modelId;
        this.setColumnPropertyNames(columnPropertyNames);
        this.init();
    }

    public void setInitialData(Object[] initialData) {
        this.initialData = initialData;
    }

    public Object[] getInitialData() {
        if (this.initialData == null) {
            this.initialData = this.getDefaultInitialData();
        }
        return this.initialData;
    }

    public EventList getBaseEventList() {
        if (this.baseList == null) {
            Object[] data = this.getInitialData();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Table data: got " + data.length + " entries"));
            }
            EventList rawList = GlazedLists.eventList(Arrays.asList(data));
            int initialSortColumn = this.getInitialSortColumn();
            if (initialSortColumn >= 0) {
                String sortProperty = this.getColumnPropertyNames()[initialSortColumn];
                this.baseList = new SortedList(rawList, (Comparator)new PropertyComparator(sortProperty, false, true));
            } else {
                this.baseList = new SortedList(rawList);
            }
        }
        return this.baseList;
    }

    public void setFinalEventList(EventList finalEventList) {
        this.finalEventList = finalEventList;
    }

    public EventList getFinalEventList() {
        if (this.finalEventList == null) {
            this.finalEventList = this.getBaseEventList();
        }
        return this.finalEventList;
    }

    public GlazedTableModel getTableModel() {
        return this.model;
    }

    public String[] getColumnPropertyNames() {
        return this.columnPropertyNames;
    }

    public void setColumnPropertyNames(String[] columnPropertyNames) {
        this.columnPropertyNames = columnPropertyNames;
    }

    public ActionCommandExecutor getDoubleClickHandler() {
        return this.doubleClickHandler;
    }

    public void setDoubleClickHandler(ActionCommandExecutor doubleClickHandler) {
        this.doubleClickHandler = doubleClickHandler;
    }

    protected AbstractTableComparatorChooser getTableSorter() {
        return this.tableSorter;
    }

    public CommandGroup getPopupCommandGroup() {
        return this.popupCommandGroup;
    }

    public void setPopupCommandGroup(CommandGroup popupCommandGroup) {
        this.popupCommandGroup = popupCommandGroup;
    }

    public void setStatusBar(StatusBar statusBar) {
        this.statusBar = statusBar;
        this.updateStatusBar();
    }

    public String getModelId() {
        return this.modelId;
    }

    protected void init() {
        this.objectSingularName = this.getMessage(this.modelId + ".objectName.singular");
        this.objectPluralName = this.getMessage(this.modelId + ".objectName.plural");
    }

    protected JComponent createControl() {
        EventList finalEventList = this.getFinalEventList();
        this.model = this.createTableModel(finalEventList);
        JTable table = this.getComponentFactory().createTable((TableModel)((Object)this.model));
        table.setSelectionModel((ListSelectionModel)new EventSelectionModel(finalEventList));
        table.setSelectionMode(2);
        Assert.notNull((Object)this.baseList);
        this.tableSorter = this.createTableSorter(table, this.baseList);
        this.configureTable(table);
        int initialSortColumn = this.getInitialSortColumn();
        if (initialSortColumn >= 0) {
            this.tableSorter.clearComparator();
            this.tableSorter.appendComparator(initialSortColumn, 0, false);
        }
        table.addMouseListener((MouseListener)((Object)new ContextPopupMenuListener()));
        table.addMouseListener(new DoubleClickListener());
        StatusBarUpdateListener statusBarUpdateListener = new StatusBarUpdateListener();
        table.getSelectionModel().addListSelectionListener(statusBarUpdateListener);
        this.getFinalEventList().addListEventListener((ListEventListener)statusBarUpdateListener);
        return table;
    }

    protected void configureTable(JTable table) {
    }

    protected abstract Object[] getDefaultInitialData();

    protected JTable getTable() {
        return (JTable)this.getControl();
    }

    protected AbstractTableComparatorChooser createTableSorter(JTable table, SortedList sortedList) {
        return new TableComparatorChooser(table, sortedList, this.isMultipleColumnSort());
    }

    protected boolean isMultipleColumnSort() {
        return true;
    }

    protected void onDoubleClick() {
        if (this.doubleClickHandler != null) {
            boolean okToExecute = true;
            if (this.doubleClickHandler instanceof GuardedActionCommandExecutor) {
                okToExecute = ((GuardedActionCommandExecutor)this.doubleClickHandler).isEnabled();
            }
            if (okToExecute) {
                this.doubleClickHandler.execute();
            }
        }
    }

    protected GlazedTableModel createTableModel(EventList eventList) {
        return new GlazedTableModel(eventList, this.getColumnPropertyNames(), this.modelId){

            protected TableFormat createTableFormat() {
                return new GlazedTableModel.DefaultAdvancedTableFormat(this);
            }
        };
    }

    protected boolean shouldHandleEvent(ApplicationEvent event) {
        return true;
    }

    protected JPopupMenu createPopupContextMenu() {
        return this.getPopupCommandGroup() != null ? this.getPopupCommandGroup().createPopupMenu() : null;
    }

    protected JPopupMenu createPopupContextMenu(MouseEvent e) {
        return this.createPopupContextMenu();
    }

    protected int getInitialSortColumn() {
        return 0;
    }

    public ListSelectionModel getSelectionModel() {
        return this.getTable().getSelectionModel();
    }

    protected void runWithWriteLock(Runnable runnable) {
        this.runWithLock(runnable, this.getFinalEventList().getReadWriteLock().writeLock());
    }

    protected void runWithReadLock(Runnable runnable) {
        this.runWithLock(runnable, this.getFinalEventList().getReadWriteLock().readLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithLock(Runnable runnable, Lock lock) {
        Assert.notNull((Object)runnable);
        Assert.notNull((Object)lock);
        lock.lock();
        try {
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }

    protected void handleNewObject(final Object object) {
        this.runWithWriteLock(new Runnable(){

            public void run() {
                AbstractObjectTable.this.getFinalEventList().add(object);
            }
        });
    }

    protected void handleUpdatedObject(final Object object) {
        this.runWithWriteLock(new Runnable(){

            public void run() {
                int index = AbstractObjectTable.this.getFinalEventList().indexOf(object);
                if (index >= 0) {
                    AbstractObjectTable.this.getFinalEventList().set(index, object);
                }
            }
        });
    }

    protected void handleDeletedObject(final Object object) {
        this.runWithWriteLock(new Runnable(){

            public void run() {
                int index = AbstractObjectTable.this.getFinalEventList().indexOf(object);
                if (index >= 0) {
                    AbstractObjectTable.this.getFinalEventList().remove(index);
                }
            }
        });
    }

    protected void updateStatusBar() {
        if (this.statusBar != null) {
            String msg;
            String[] keys;
            int showing;
            int all = this.getBaseEventList().size();
            if (all == (showing = this.getFinalEventList().size())) {
                keys = new String[]{this.modelId + "." + SHOWINGALL_MSG_KEY, SHOWINGALL_MSG_KEY};
                msg = this.getMessage(keys, new Object[]{"" + all, all != 1 ? this.objectPluralName : this.objectSingularName});
            } else {
                keys = new String[]{this.modelId + "." + SHOWINGN_MSG_KEY, SHOWINGN_MSG_KEY};
                msg = this.getMessage(keys, new Object[]{"" + showing, showing != 1 ? this.objectPluralName : this.objectSingularName, "" + all});
            }
            int nselected = this.getTable().getSelectedRowCount();
            if (nselected > 0) {
                String[] keys2 = new String[]{this.modelId + "." + SELECTEDN_MSG_KEY, SELECTEDN_MSG_KEY};
                msg = msg + this.getMessage(keys2, new Object[]{"" + nselected});
            }
            this.statusBar.setMessage(msg.toString());
        }
    }

    public void onApplicationEvent(ApplicationEvent e) {
        if (e instanceof LifecycleApplicationEvent) {
            LifecycleApplicationEvent le = (LifecycleApplicationEvent)e;
            if (this.shouldHandleEvent(e)) {
                if (le.getEventType() == "lifecycleEvent.created") {
                    this.handleNewObject(le.getObject());
                } else if (le.getEventType() == "lifecycleEvent.modified") {
                    this.handleUpdatedObject(le.getObject());
                } else if (le.getEventType() == "lifecycleEvent.deleted") {
                    this.handleDeletedObject(le.getObject());
                }
            }
        }
    }

    final class StatusBarUpdateListener
    implements ListSelectionListener,
    ListEventListener {
        StatusBarUpdateListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            AbstractObjectTable.this.updateStatusBar();
        }

        public void listChanged(ListEvent listChanges) {
            AbstractObjectTable.this.updateStatusBar();
        }
    }

    final class DoubleClickListener
    extends MouseAdapter {
        DoubleClickListener() {
        }

        public void mousePressed(MouseEvent e) {
            int rowUnderMouse;
            if (e.getButton() == 3 && (rowUnderMouse = AbstractObjectTable.this.getTable().rowAtPoint(e.getPoint())) != -1 && !AbstractObjectTable.this.getTable().isRowSelected(rowUnderMouse)) {
                AbstractObjectTable.this.getSelectionModel().setSelectionInterval(rowUnderMouse, rowUnderMouse);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                AbstractObjectTable.this.onDoubleClick();
            }
        }
    }

    final class ContextPopupMenuListener
    extends PopupMenuMouseListener {
        ContextPopupMenuListener() {
        }

        protected JPopupMenu getPopupMenu(MouseEvent e) {
            return AbstractObjectTable.this.createPopupContextMenu(e);
        }
    }
}

