/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.table.support;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.EventTableModel;
import java.util.Comparator;
import java.util.HashMap;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.binding.form.FieldFaceSource;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GlazedTableModel
extends EventTableModel {
    private static final EventList EMPTY_LIST = new BasicEventList();
    private final BeanWrapper beanWrapper = new BeanWrapperImpl();
    private String[] columnLabels;
    private final String[] columnPropertyNames;
    private final String modelId;
    private FieldFaceSource fieldFaceSource;
    static /* synthetic */ Class class$java$lang$Object;

    public GlazedTableModel(String[] columnPropertyNames) {
        this(EMPTY_LIST, columnPropertyNames);
    }

    public GlazedTableModel(Class beanClass, EventList rows, String[] columnPropertyNames) {
        this(rows, columnPropertyNames, ClassUtils.getShortName((Class)beanClass));
    }

    public GlazedTableModel(EventList rows, String[] columnPropertyNames) {
        this(rows, columnPropertyNames, null);
    }

    public GlazedTableModel(EventList rows, String[] columnPropertyNames, String modelId) {
        super(rows, null);
        Assert.notEmpty((Object[])columnPropertyNames, (String)"ColumnPropertyNames parameter cannot be null.");
        this.modelId = modelId;
        this.columnPropertyNames = columnPropertyNames;
        this.setTableFormat(this.createTableFormat());
    }

    public void setFieldFaceSource(FieldFaceSource fieldFaceSource) {
        this.fieldFaceSource = fieldFaceSource;
    }

    protected FieldFaceSource getFieldFaceSource() {
        if (this.fieldFaceSource == null) {
            this.fieldFaceSource = (FieldFaceSource)ApplicationServicesLocator.services().getService(FieldFaceSource.class);
        }
        return this.fieldFaceSource;
    }

    protected Object getColumnValue(Object row, int column) {
        this.beanWrapper.setWrappedInstance(row);
        return this.beanWrapper.getPropertyValue(this.columnPropertyNames[column]);
    }

    protected String[] getColumnLabels() {
        if (this.columnLabels == null) {
            this.columnLabels = this.createColumnNames(this.columnPropertyNames);
        }
        return this.columnLabels;
    }

    protected String[] getColumnPropertyNames() {
        return this.columnPropertyNames;
    }

    public String getModelId() {
        return this.modelId;
    }

    protected boolean isEditable(Object row, int column) {
        this.beanWrapper.setWrappedInstance(row);
        return this.beanWrapper.isWritableProperty(this.columnPropertyNames[column]);
    }

    protected Object setColumnValue(Object row, Object value, int column) {
        this.beanWrapper.setWrappedInstance(row);
        this.beanWrapper.setPropertyValue(this.columnPropertyNames[column], value);
        return row;
    }

    protected String[] createColumnNames(String[] propertyColumnNames) {
        int size = propertyColumnNames.length;
        String[] columnNames = new String[size];
        FieldFaceSource source = this.getFieldFaceSource();
        for (int i = 0; i < size; ++i) {
            columnNames[i] = source.getFieldFace(propertyColumnNames[i], (Object)this.getModelId()).getLabelInfo().getText();
        }
        return columnNames;
    }

    protected TableFormat createTableFormat() {
        return new DefaultTableFormat();
    }

    protected class DefaultAdvancedTableFormat
    implements AdvancedTableFormat {
        private HashMap comparators = new HashMap();
        private HashMap columnClasses = new HashMap();
        private Object prototype;
        private BeanWrapper beanWrapper;

        public int getColumnCount() {
            return GlazedTableModel.this.getColumnLabels().length;
        }

        public String getColumnName(int column) {
            return GlazedTableModel.this.getColumnLabels()[column];
        }

        public Object getColumnValue(Object row, int column) {
            return GlazedTableModel.this.getColumnValue(row, column);
        }

        public Class getColumnClass(int column) {
            Integer columnKey = new Integer(column);
            Class<?> cls = (Class<?>)this.columnClasses.get(columnKey);
            if (cls == null) {
                if (this.prototype != null) {
                    cls = this.beanWrapper.getPropertyType(GlazedTableModel.this.getColumnPropertyNames()[column]);
                } else {
                    int rowCount = GlazedTableModel.this.getRowCount();
                    for (int row = 0; cls == null && row < rowCount; ++row) {
                        Object obj = GlazedTableModel.this.getValueAt(row, column);
                        if (obj == null) continue;
                        cls = obj.getClass();
                    }
                }
            }
            if (cls != null) {
                this.columnClasses.put(columnKey, cls);
            } else {
                cls = class$java$lang$Object == null ? (class$java$lang$Object = GlazedTableModel.class$("java.lang.Object")) : class$java$lang$Object;
            }
            return cls;
        }

        public Comparator getColumnComparator(int column) {
            Comparator comparator = (Comparator)this.comparators.get(new Integer(column));
            return comparator != null ? comparator : GlazedLists.comparableComparator();
        }

        public void setComparator(int column, Comparator comparator) {
            this.comparators.put(new Integer(column), comparator);
        }

        public void setPrototypeValue(Object prototype) {
            this.prototype = prototype;
            this.beanWrapper = new BeanWrapperImpl(this.prototype);
        }
    }

    protected class DefaultTableFormat
    implements WritableTableFormat {
        protected DefaultTableFormat() {
        }

        public int getColumnCount() {
            return GlazedTableModel.this.getColumnLabels().length;
        }

        public String getColumnName(int column) {
            return GlazedTableModel.this.getColumnLabels()[column];
        }

        public Object getColumnValue(Object row, int column) {
            return GlazedTableModel.this.getColumnValue(row, column);
        }

        public boolean isEditable(Object row, int column) {
            return GlazedTableModel.this.isEditable(row, column);
        }

        public Object setColumnValue(Object row, Object value, int column) {
            return GlazedTableModel.this.setColumnValue(row, value, column);
        }
    }
}

