/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.rules.metadata;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.closure.Constraint;
import org.springframework.metadata.Attributes;
import org.springframework.rules.Rules;
import org.springframework.rules.constraint.property.CompoundPropertyConstraint;
import org.springframework.rules.constraint.property.PropertyConstraint;
import org.springframework.rules.support.DefaultRulesSource;

public class AttributesRulesSource
extends DefaultRulesSource {
    private final Attributes attributes;

    public AttributesRulesSource(Attributes attributes) {
        this.attributes = attributes;
    }

    public synchronized Rules getRules(Class beanClass, String contextId) {
        Rules rules = super.getRules(beanClass, contextId);
        if (rules == null) {
            this.buildRules(beanClass);
            rules = super.getRules(beanClass, contextId);
        }
        return rules;
    }

    private void buildRules(Class beanClass) {
        Rules rules = new Rules(beanClass);
        PropertyDescriptor[] propertDescriptors = new BeanWrapperImpl(beanClass).getPropertyDescriptors();
        for (int i = 0; i < propertDescriptors.length; ++i) {
            this.loadPropertyConstraints(rules, propertDescriptors[i]);
        }
        this.addRules(rules);
    }

    private void loadPropertyConstraints(Rules rules, PropertyDescriptor propertDescriptor) {
        String propertyName = propertDescriptor.getName();
        this.loadPropertyConstraintsForMethod(rules, propertyName, propertDescriptor.getReadMethod());
        this.loadPropertyConstraintsForMethod(rules, propertyName, propertDescriptor.getWriteMethod());
    }

    private void loadPropertyConstraintsForMethod(Rules rules, String propertyName, Method method) {
        if (method != null) {
            Iterator i = this.attributes.getAttributes(method).iterator();
            while (i.hasNext()) {
                Object attribute = i.next();
                if (!(attribute instanceof Constraint)) continue;
                Constraint constraint = (Constraint)attribute;
                if (constraint instanceof PropertyConstraint) {
                    rules.add((PropertyConstraint)constraint);
                    continue;
                }
                if (constraint instanceof CompoundPropertyConstraint) {
                    rules.add((PropertyConstraint)((CompoundPropertyConstraint)constraint));
                    continue;
                }
                rules.add(propertyName, constraint);
            }
        }
    }
}

