/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller.util;

import cool.pandora.modeller.ModellerClient;
import cool.pandora.modeller.ModellerClientFailedException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Selector;
import org.apache.jena.rdf.model.SimpleSelector;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;

public class ResourceIntegerValue {
    private List<Integer> resourceValue;

    public static ResourceValueBuilder init() {
        return new ResourceValueBuilder();
    }

    public List<Integer> render() {
        return this.resourceValue;
    }

    ResourceIntegerValue(String resourceURI, String resourceProperty) {
        try {
            String resource = ModellerClient.doGetContainerResources(new URI(resourceURI));
            Model model = ModelFactory.createDefaultModel();
            model.read((InputStream)new ByteArrayInputStream(resource != null ? resource.getBytes() : new byte[]{}), null, "TTL");
            this.resourceValue = ResourceIntegerValue.getValue(model, resourceProperty);
        }
        catch (ModellerClientFailedException e) {
            System.out.println(ExceptionUtils.getMessage((Throwable)e));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static ArrayList<Integer> getValue(Model model, String resourceProperty) {
        Property property = model.getProperty(resourceProperty);
        ArrayList<Integer> retval = new ArrayList<Integer>();
        StmtIterator it = model.listStatements((Selector)new SimpleSelector(null, property, (RDFNode)((Resource)null)));
        while (it.hasNext()) {
            Statement st = (Statement)it.next();
            retval.add(st.getInt());
        }
        return retval;
    }

    public static class ResourceValueBuilder {
        private String resourceURI;
        private String resourceProperty;

        public ResourceValueBuilder resourceURI(String resourceURI) {
            this.resourceURI = resourceURI;
            return this;
        }

        public ResourceValueBuilder resourceProperty(String resourceProperty) {
            this.resourceProperty = resourceProperty;
            return this;
        }

        public ResourceIntegerValue build() {
            return new ResourceIntegerValue(this.resourceURI, this.resourceProperty);
        }
    }
}

