/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.client;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FcrepoHttpClientBuilder {
    private String username;
    private String password;
    private String host;
    private static final Logger LOGGER = LoggerFactory.getLogger(FcrepoHttpClientBuilder.class);

    public FcrepoHttpClientBuilder(String username, String password, String host) {
        this.username = username;
        this.password = password;
        this.host = host;
    }

    public CloseableHttpClient build() {
        if (StringUtils.isBlank((CharSequence)this.username) || StringUtils.isBlank((CharSequence)this.password)) {
            return HttpClients.createSystem();
        }
        LOGGER.debug("Accessing fcrepo with user credentials");
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        AuthScope scope = null;
        scope = StringUtils.isBlank((CharSequence)this.host) ? new AuthScope(AuthScope.ANY) : new AuthScope(new HttpHost(this.host));
        credsProvider.setCredentials(scope, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        return HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).useSystemProperties().addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor()).build();
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                AuthScope authScope;
                CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials creds = credsProvider.getCredentials(authScope = new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (creds == null) {
                    LOGGER.debug("Cannot initiate preemtive authentication, Credentials not found!");
                }
                authState.update((AuthScheme)new BasicScheme(), creds);
            }
        }
    }
}

