/*
 * Decompiled with CFR 0.152.
 */
package cool.pandora.modeller;

import cool.pandora.modeller.OmitDTDXMLFactoriesConfig;
import cool.pandora.modeller.hOCRData;
import cool.pandora.modeller.util.RDFCollectionWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang3.StringUtils;
import org.xmlbeam.XBProjector;
import org.xmlbeam.config.XMLFactoriesConfig;

public class DocManifestBuilder {
    private DocManifestBuilder() {
    }

    public static hOCRData gethOCRProjectionFromURL(String url) throws IOException {
        return (hOCRData)new XBProjector((XMLFactoriesConfig)new OmitDTDXMLFactoriesConfig(), new XBProjector.Flags[0]).io().url(url).read(hOCRData.class);
    }

    private static Map<String, Object> buildValueMap(List<String> descList, hOCRData hocr) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (String descId : descList) {
            String oNode = hocr.getTitleForId(descId);
            valueMap.put(descId, oNode);
        }
        return valueMap;
    }

    public static Map getAreaMapForhOCRResource(hOCRData hocr) {
        List<String> cAreaIdList = hocr.getCAreaNodeId();
        HashMap<String, Map<String, Object>> areaMap = new HashMap<String, Map<String, Object>>();
        for (String cAreaId : cAreaIdList) {
            List<String> descList = hocr.getCAreaIdDescIds(cAreaId);
            areaMap.put(cAreaId, DocManifestBuilder.buildValueMap(descList, hocr));
        }
        return areaMap;
    }

    static String getAreaRDFSequenceForhOCRResource(hOCRData hocr, String resourceURI) throws IOException {
        List<String> cAreaIdList = hocr.getCAreaNodeId();
        String collectionPredicate = "http://iiif.io/api/text#hasAreas";
        RDFCollectionWriter collectionWriter = RDFCollectionWriter.collection().idList(cAreaIdList).collectionPredicate("http://iiif.io/api/text#hasAreas").resourceContainerIRI(resourceURI).build();
        return collectionWriter.render();
    }

    public static List<String> getPageIdList(hOCRData hocr) {
        return hocr.getPageNodeId();
    }

    public static List<String> getAreaIdList(hOCRData hocr) {
        return hocr.getCAreaNodeId();
    }

    public static List<String> getLineIdList(hOCRData hocr) {
        return hocr.getLineNodeId();
    }

    public static List<String> getWordIdList(hOCRData hocr) {
        return hocr.getWordNodeId();
    }

    public static List<String> getAreaIdListforPage(hOCRData hocr, String id) {
        return hocr.getCAreasforPage(id);
    }

    public static List<String> getLineIdListforArea(hOCRData hocr, String id) {
        return hocr.getLinesforArea(id);
    }

    public static String getBboxForId(hOCRData hocr, String id) {
        return StringUtils.substringBefore((String)StringUtils.substringAfter((String)hocr.getTitleForId(id), (String)"bbox "), (String)";");
    }

    public static String getCharsForId(hOCRData hocr, String id) {
        return hocr.getCharsForId(id);
    }

    public static List<String> getWordIdListforLine(hOCRData hocr, String id) {
        return hocr.getWordsforLine(id);
    }

    public static List<String> getWordIdListforPage(hOCRData hocr, String id) {
        return hocr.getWordsforPage(id);
    }

    private static ByteArrayOutputStream marshal(File hocr) throws JAXBException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{File.class});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        jaxbMarshaller.marshal((Object)hocr, (OutputStream)out);
        return out;
    }
}

