/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.form.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.springframework.binding.form.FieldMetadata;
import org.springframework.binding.form.FormModel;
import org.springframework.binding.value.support.AbstractPropertyChangePublisher;

public class ReadOnlyFieldMetadata
extends AbstractPropertyChangePublisher
implements FieldMetadata {
    private Class propertyType;
    private boolean enabled = true;
    private boolean oldEnabled;
    private FormModel formModel;
    private final PropertyChangeListener formChangeHandler = new FormModelChangeHandler();
    private final Map userMetadata = new HashMap();

    public ReadOnlyFieldMetadata(FormModel formModel, Class propertyType) {
        this(formModel, propertyType, null);
    }

    public ReadOnlyFieldMetadata(FormModel formModel, Class propertyType, Map userMetadata) {
        this.propertyType = propertyType;
        this.formModel = formModel;
        this.formModel.addPropertyChangeListener("enabled", this.formChangeHandler);
        if (userMetadata != null) {
            this.userMetadata.putAll(userMetadata);
        }
    }

    public Map getAllUserMetadata() {
        return this.userMetadata;
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Object getUserMetadata(String key) {
        return this.userMetadata.get(key);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEnabled() {
        return this.enabled && this.formModel.isEnabled();
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.firePropertyChange("enabled", this.oldEnabled, this.isEnabled());
        this.oldEnabled = this.isEnabled();
    }

    public void setReadOnly(boolean readOnly) {
    }

    private class FormModelChangeHandler
    implements PropertyChangeListener {
        private FormModelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("enabled".equals(evt.getPropertyName())) {
                ReadOnlyFieldMetadata.this.firePropertyChange("enabled", ReadOnlyFieldMetadata.this.oldEnabled, ReadOnlyFieldMetadata.this.isEnabled());
                ReadOnlyFieldMetadata.this.oldEnabled = ReadOnlyFieldMetadata.this.isEnabled();
            }
        }
    }
}

