/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.support;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.binding.support.AnnotationTranslator;
import org.springframework.binding.support.BeanPropertyAccessStrategy;
import org.springframework.binding.support.ReflectionAnnotationTranslator;
import org.springframework.binding.value.ValueModel;
import org.springframework.richclient.util.AnnotationUtils;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationAwareBeanPropertyAccessStrategy
extends BeanPropertyAccessStrategy {
    private AnnotationTranslator annotationTranslator;

    public AnnotationAwareBeanPropertyAccessStrategy(Object bean) {
        super(bean);
    }

    public AnnotationAwareBeanPropertyAccessStrategy(ValueModel domainObjectHolder) {
        super(domainObjectHolder);
    }

    protected AnnotationAwareBeanPropertyAccessStrategy(BeanPropertyAccessStrategy parent, String basePropertyPath) {
        super(parent, basePropertyPath);
    }

    @Override
    protected Map<String, Object> getAllUserMetadataFor(String propertyPath) {
        PropertyDescriptor pd = this.getBeanWrapper().getPropertyDescriptor(propertyPath);
        Assert.notNull((Object)pd);
        AnnotationTranslator translator = this.getAnnotationTranslator();
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Annotation annotation : AnnotationUtils.getAnnotationsFor(pd)) {
            translator.translate(annotation, ret);
        }
        return ret;
    }

    public AnnotationTranslator getAnnotationTranslator() {
        if (this.annotationTranslator == null) {
            this.annotationTranslator = new ReflectionAnnotationTranslator();
        }
        return this.annotationTranslator;
    }

    public void setAnnotationTranslator(AnnotationTranslator annotationTranslator) {
        this.annotationTranslator = annotationTranslator;
    }
}

