/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.validation.support;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.validator.MessageInterpolator;
import org.hibernate.validator.Validator;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.richclient.application.ApplicationServicesLocator;

public class HibernateRulesMessageInterpolator
implements MessageInterpolator {
    private MessageSourceAccessor messageSourceAccessor;
    private static Log log = LogFactory.getLog(HibernateRulesMessageInterpolator.class);
    private String annotationMessage;
    private String interpolateMessage;

    private void initializeMessageSourceAccessor() {
        this.messageSourceAccessor = (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
    }

    public String interpolate(String message, Validator validator, MessageInterpolator defaultInterpolator) {
        if (this.annotationMessage != null && this.annotationMessage.equals(message)) {
            return this.interpolateMessage;
        }
        message = message.replaceAll("[\\{\\}]", "");
        String string = null;
        String string2 = string = this.messageSourceAccessor != null ? this.messageSourceAccessor.getMessage(message, new Object[0], Locale.getDefault()) : null;
        if (StringUtils.isEmpty(string)) {
            log.info((Object)"Message not found in messageSourceAccessor (it may not exist), trying Hibernate default messages");
            return defaultInterpolator.interpolate(message, validator, defaultInterpolator);
        }
        return string;
    }

    public HibernateRulesMessageInterpolator() {
        this.initializeMessageSourceAccessor();
    }
}

