/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.springframework.binding.value.ValueChangeDetector;

public class DefaultValueChangeDetector
implements ValueChangeDetector {
    protected final Set classesWithSafeEquals = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Character.class, BigDecimal.class, BigInteger.class, Date.class, Calendar.class));

    public boolean hasValueChanged(Object oldValue, Object newValue) {
        if (oldValue != null && this.classesWithSafeEquals.contains(oldValue.getClass())) {
            return !oldValue.equals(newValue);
        }
        return oldValue != newValue;
    }

    public void setClassesWithSafeEquals(Collection classes) {
        this.classesWithSafeEquals.clear();
        this.classesWithSafeEquals.addAll(classes);
    }

    public Collection getClassesWithSafeEquals() {
        return this.classesWithSafeEquals;
    }
}

