/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.value.support;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.binding.value.IndexAdapter;
import org.springframework.binding.value.ValueModel;
import org.springframework.binding.value.support.AbstractIndexAdapter;

public class GrowableIndexAdapter
extends AbstractIndexAdapter
implements IndexAdapter {
    private boolean autoGrow;
    private ValueModel collectionValueModel;

    public GrowableIndexAdapter(boolean autoGrow, ValueModel collectionValueModel) {
        this.autoGrow = autoGrow;
        this.collectionValueModel = collectionValueModel;
    }

    public boolean isAutoGrow() {
        return this.autoGrow;
    }

    public void fireIndexedObjectChanged() {
    }

    public Object getValue() {
        return this.getCollectionValue(this.getIndex());
    }

    protected Object getCollectionValue(int index) {
        Object collection = this.collectionValueModel.getValue();
        if (collection.getClass().isArray()) {
            this.growArrayIfNeccessary(index);
            return Array.get(collection, index);
        }
        if (collection instanceof List) {
            this.growCollectionIfNeccessary(index);
            return ((List)collection).get(index);
        }
        if (collection instanceof Set) {
            this.growCollectionIfNeccessary(index);
            Set setValue = (Set)collection;
            Iterator it = setValue.iterator();
            int j = 0;
            while (it.hasNext()) {
                Object element = it.next();
                if (j == index) {
                    return element;
                }
                ++j;
            }
            return null;
        }
        throw new IllegalArgumentException("Value must be a collection " + collection);
    }

    public void setValue(Object value) {
        Object oldValue = this.setCollectionValue(this.getIndex(), value);
        this.fireValueChange(oldValue, value);
    }

    protected Object setCollectionValue(int index, Object value) {
        Object collection = this.collectionValueModel.getValue();
        if (collection.getClass().isArray()) {
            this.growArrayIfNeccessary(index);
            Object old = Array.get(value, index);
            Array.set(collection, index, value);
            return old;
        }
        if (collection instanceof List) {
            this.growCollectionIfNeccessary(index);
            return ((List)value).set(index, value);
        }
        if (collection instanceof Set) {
            this.growCollectionIfNeccessary(index);
            Set setValue = (Set)value;
            Iterator it = setValue.iterator();
            Object old = null;
            int j = 0;
            while (it.hasNext()) {
                Object element = it.next();
                if (j == index) {
                    old = element;
                    it.remove();
                }
                ++j;
            }
            setValue.add(value);
            return old;
        }
        throw new IllegalArgumentException("Value must be a collection " + value);
    }

    private void growArrayIfNeccessary(int index) {
        Object value = this.collectionValueModel.getValue();
        if (this.isAutoGrow() && index >= Array.getLength(value)) {
            value = Array.newInstance(value.getClass(), index + 1);
            Object newArray = Array.get(value, index);
            System.arraycopy(value, 0, newArray, 0, Array.getLength(value));
            this.collectionValueModel.setValue(newArray);
        }
    }

    private void growCollectionIfNeccessary(int index) {
        block3: {
            Object value;
            block4: {
                if (!this.isAutoGrow()) break block3;
                value = this.collectionValueModel.getValue();
                if (!(value instanceof List)) break block4;
                List listValue = (List)value;
                if (!this.isAutoGrow()) break block3;
                while (index >= listValue.size()) {
                    listValue.add(null);
                }
                break block3;
            }
            if (value instanceof Set) {
                Set setValue = (Set)value;
                while (index >= setValue.size()) {
                    setValue.add(null);
                }
            }
        }
    }
}

