/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application;

import java.awt.Image;
import java.util.Observable;
import java.util.Observer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.richclient.application.ApplicationDescriptor;
import org.springframework.richclient.application.ApplicationPageFactory;
import org.springframework.richclient.application.ApplicationServices;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.ApplicationWindowFactory;
import org.springframework.richclient.application.WindowManager;
import org.springframework.richclient.application.config.ApplicationLifecycleAdvisor;
import org.springframework.richclient.application.config.DefaultApplicationLifecycleAdvisor;
import org.springframework.richclient.application.support.DefaultApplicationServices;
import org.springframework.richclient.application.support.MultiViewPageDescriptor;
import org.springframework.richclient.image.ImageSource;
import org.springframework.richclient.image.NoSuchImageResourceException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Application
implements InitializingBean,
ApplicationContextAware {
    private static final String DEFAULT_APPLICATION_IMAGE_KEY = "applicationInfo.image";
    private static Application SOLE_INSTANCE;
    private ApplicationContext applicationContext;
    private ApplicationDescriptor descriptor;
    private ApplicationLifecycleAdvisor lifecycleAdvisor;
    private WindowManager windowManager;
    private boolean forceShutdown = false;

    public static void load(Application instance) {
        SOLE_INSTANCE = instance;
    }

    public static Application instance() {
        Assert.state((boolean)Application.isLoaded(), (String)"The global rich client application instance has not yet been initialized; it must be created and loaded first.");
        return SOLE_INSTANCE;
    }

    public static boolean isLoaded() {
        return SOLE_INSTANCE != null;
    }

    public static ApplicationServices services() {
        if (!ApplicationServicesLocator.isLoaded()) {
            ApplicationServicesLocator.load(new ApplicationServicesLocator(new DefaultApplicationServices()));
        }
        return ApplicationServicesLocator.services();
    }

    public Application() {
        this(new DefaultApplicationLifecycleAdvisor());
    }

    public Application(ApplicationLifecycleAdvisor advisor) {
        this(null, advisor);
    }

    public Application(ApplicationDescriptor descriptor, ApplicationLifecycleAdvisor advisor) {
        this.setDescriptor(descriptor);
        this.setLifecycleAdvisor(advisor);
        this.windowManager = new WindowManager();
        this.windowManager.addObserver(new CloseApplicationObserver());
        Assert.state((!Application.isLoaded() ? 1 : 0) != 0, (String)"Only one instance of a Spring Rich Application allowed per VM.");
        Application.load(this);
    }

    public void setDescriptor(ApplicationDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public ApplicationDescriptor getDescriptor() {
        return this.descriptor;
    }

    private void setLifecycleAdvisor(ApplicationLifecycleAdvisor advisor) {
        this.lifecycleAdvisor = advisor;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.applicationContext = context;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.lifecycleAdvisor, (String)"The application advisor is required, for processing of application lifecycle events");
        this.getLifecycleAdvisor().setApplication(this);
        this.getLifecycleAdvisor().onPreInitialize(this);
    }

    public ApplicationLifecycleAdvisor getLifecycleAdvisor() {
        return this.lifecycleAdvisor;
    }

    public String getName() {
        if (this.descriptor != null && StringUtils.hasText((String)this.descriptor.getDisplayName())) {
            return this.descriptor.getDisplayName();
        }
        return "Spring Rich Client Application";
    }

    public Image getImage() {
        if (this.descriptor != null && this.descriptor.getImage() != null) {
            return this.descriptor.getImage();
        }
        try {
            ImageSource isrc = (ImageSource)Application.services().getService(ImageSource.class);
            return isrc.getImage(DEFAULT_APPLICATION_IMAGE_KEY);
        }
        catch (NoSuchImageResourceException e) {
            return null;
        }
    }

    public void openWindow(String pageDescriptorId) {
        ApplicationWindow newWindow = this.initWindow(this.createNewWindow());
        if (pageDescriptorId == null) {
            ApplicationPageFactory pageFactory = (ApplicationPageFactory)Application.services().getService(ApplicationPageFactory.class);
            newWindow.showPage(pageFactory.createApplicationPage(newWindow, new MultiViewPageDescriptor()));
        } else {
            newWindow.showPage(pageDescriptorId);
        }
    }

    private ApplicationWindow initWindow(ApplicationWindow window) {
        this.windowManager.add(window);
        return window;
    }

    protected ApplicationWindow createNewWindow() {
        ApplicationWindowFactory windowFactory = (ApplicationWindowFactory)Application.services().getService(ApplicationWindowFactory.class);
        return windowFactory.createApplicationWindow();
    }

    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    public ApplicationWindow getActiveWindow() {
        return this.windowManager.getActiveWindow();
    }

    public boolean isForceShutdown() {
        return this.forceShutdown;
    }

    public void close() {
        this.close(false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force, int exitCode) {
        this.forceShutdown = force;
        try {
            if (this.windowManager.close()) {
                this.forceShutdown = true;
                if (this.getApplicationContext() instanceof ConfigurableApplicationContext) {
                    ((ConfigurableApplicationContext)this.getApplicationContext()).close();
                }
                this.getLifecycleAdvisor().onShutdown();
            }
        }
        finally {
            if (this.isForceShutdown()) {
                System.exit(exitCode);
            }
        }
    }

    public void start() {
        this.getLifecycleAdvisor().onPreStartup();
        this.openWindow(this.getLifecycleAdvisor().getStartingPageId());
        this.getLifecycleAdvisor().onPostStartup();
    }

    private class CloseApplicationObserver
    implements Observer {
        boolean firstWindowCreated = false;

        private CloseApplicationObserver() {
        }

        public void update(Observable o, Object arg) {
            int numOpenWidows = Application.this.windowManager.getWindows().length;
            if (!this.firstWindowCreated && numOpenWidows > 0) {
                this.firstWindowCreated = true;
            } else if (this.firstWindowCreated && numOpenWidows == 0) {
                Application.this.close();
            }
        }
    }
}

