/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.command.ActionCommand;

public class DefaultButtonFocusListener
implements PropertyChangeListener {
    public static final String DEFAULT_COMMAND = "defaultCommand";
    private static final transient Log log = LogFactory.getLog(DefaultButtonFocusListener.class);

    public DefaultButtonFocusListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Component comp = (Component)evt.getNewValue();
        if (comp != null && comp instanceof JComponent) {
            JComponent jcomp = (JComponent)comp;
            while (jcomp != null && jcomp.getClientProperty(DEFAULT_COMMAND) == null) {
                if (jcomp.getParent() instanceof JComponent) {
                    JComponent newParent = (JComponent)jcomp.getParent();
                    if (newParent == jcomp) {
                        jcomp = null;
                        continue;
                    }
                    jcomp = newParent;
                    continue;
                }
                jcomp = null;
            }
            if (jcomp != null) {
                ActionCommand command = (ActionCommand)jcomp.getClientProperty(DEFAULT_COMMAND);
                command.setDefaultButton();
            }
        }
    }

    public static void setDefaultButton(JComponent comp, ActionCommand command) {
        comp.putClientProperty(DEFAULT_COMMAND, command);
    }
}

