/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.MessageSource;
import org.springframework.richclient.progress.ProgressMonitor;
import org.springframework.util.Assert;

public class ProgressMonitoringBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public static final String LOADING_APP_CONTEXT_KEY = "progress.loading.applicationContext";
    public static final String LOADING_BEAN_KEY = "progress.loading.bean";
    private static final Log logger = LogFactory.getLog(ProgressMonitoringBeanFactoryPostProcessor.class);
    private final ProgressMonitor progressMonitor;
    private final MessageSource messageSource;
    private final String loadingAppContextMessage;

    public ProgressMonitoringBeanFactoryPostProcessor(ProgressMonitor progressMonitor, MessageSource messageSource) {
        Assert.notNull((Object)progressMonitor, (String)"The ProgressMonitor cannot be null");
        this.progressMonitor = progressMonitor;
        this.messageSource = messageSource;
        this.loadingAppContextMessage = this.getLoadingAppContextMessage();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory == null) {
            return;
        }
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        int singletonBeanCount = 0;
        for (int i = 0; i < beanNames.length; ++i) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanNames[i]);
            if (!beanDefinition.isSingleton()) continue;
            ++singletonBeanCount;
        }
        this.progressMonitor.taskStarted(this.loadingAppContextMessage, singletonBeanCount);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ProgressMonitoringBeanPostProcessor((ConfigurableBeanFactory)beanFactory));
    }

    private String getLoadingAppContextMessage() {
        String defaultMessage = "Loading Application Context ...";
        if (this.messageSource == null) {
            return defaultMessage;
        }
        return this.messageSource.getMessage(LOADING_APP_CONTEXT_KEY, null, defaultMessage, null);
    }

    private class ProgressMonitoringBeanPostProcessor
    implements BeanPostProcessor {
        private final ConfigurableBeanFactory beanFactory;

        private ProgressMonitoringBeanPostProcessor(ConfigurableBeanFactory beanFactory) {
            Assert.notNull((Object)beanFactory, (String)"The bean factory cannot be null");
            this.beanFactory = beanFactory;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("BEGIN: postProcessBeforeInitialization(" + beanName + ")"));
            }
            if (this.beanFactory.containsLocalBean(beanName)) {
                String loadingBeanMessage = this.getLoadingBeanMessage(beanName);
                ProgressMonitoringBeanFactoryPostProcessor.this.progressMonitor.subTaskStarted(loadingBeanMessage);
                ProgressMonitoringBeanFactoryPostProcessor.this.progressMonitor.worked(1);
            }
            logger.trace((Object)"END: postProcessBeforeInitialization()");
            return bean;
        }

        private String getLoadingBeanMessage(String beanName) {
            String defaultMessage = "Loading " + beanName + " ...";
            if (ProgressMonitoringBeanFactoryPostProcessor.this.messageSource == null) {
                return defaultMessage;
            }
            Object[] args = new Object[]{beanName};
            return ProgressMonitoringBeanFactoryPostProcessor.this.messageSource.getMessage(ProgressMonitoringBeanFactoryPostProcessor.LOADING_BEAN_KEY, args, defaultMessage, null);
        }
    }
}

