/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application;

import org.springframework.richclient.application.ConfigurationException;

public class PropertyNotSetException
extends ConfigurationException {
    private static final long serialVersionUID = 6848949416219396182L;
    private final Class beanClass;
    private final String propertyName;

    public static void throwIfNull(Object propertyValue, String propertyName, Class beanClass) {
        if (propertyValue == null) {
            throw new PropertyNotSetException(beanClass, propertyName);
        }
    }

    public PropertyNotSetException(Class beanClass, String propertyName) {
        this("The [" + propertyName + "] property of class [" + beanClass + "] has not been initialized.", beanClass, propertyName);
    }

    private PropertyNotSetException(String message, Class beanClass, String propertyName) {
        super(message);
        this.beanClass = beanClass;
        this.propertyName = propertyName;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

