/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application;

public class ServiceNotFoundException
extends RuntimeException {
    private static final long serialVersionUID = 4732373005271272964L;
    private final Class serviceClass;

    private static String createDefaultMessage(Class serviceClass) {
        if (serviceClass != null) {
            return "Unable to locate an application service of type [" + serviceClass.getName() + "]";
        }
        return "Unable to locate an application service. The type of the service is either unknown or was not provided when this exception was created.";
    }

    public ServiceNotFoundException(Class serviceClass) {
        super(ServiceNotFoundException.createDefaultMessage(serviceClass));
        this.serviceClass = serviceClass;
    }

    public ServiceNotFoundException(String message, Class serviceClass) {
        super(message);
        this.serviceClass = serviceClass;
    }

    public ServiceNotFoundException(String message, Class serviceClass, Throwable cause) {
        super(message, cause);
        this.serviceClass = serviceClass;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }
}

