/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.setup;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.springframework.core.io.Resource;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.ToggleCommand;
import org.springframework.richclient.layout.GridBagLayoutBuilder;
import org.springframework.richclient.text.HtmlPane;
import org.springframework.richclient.util.LabelUtils;
import org.springframework.richclient.wizard.AbstractWizardPage;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class SetupLicenseWizardPage
extends AbstractWizardPage {
    private HtmlPane licenseTextPane;
    private Resource licenseTextLocation;

    public SetupLicenseWizardPage() {
        this((Resource)null);
    }

    public SetupLicenseWizardPage(Resource licenseTextLocation) {
        super("license");
        this.setLicenseTextLocation(licenseTextLocation);
    }

    public final void setLicenseTextLocation(Resource location) {
        this.licenseTextLocation = location;
        if (this.licenseTextPane != null) {
            this.updateLicenseTextPane();
        }
    }

    protected JComponent createControl() {
        this.initLicenseTextPane();
        ToggleCommand acceptCommand = new ToggleCommand("acceptLicenseCommand"){

            protected void onSelection() {
                SetupLicenseWizardPage.this.setEnabled(true);
            }
        };
        ToggleCommand doNotAcceptCommand = new ToggleCommand("doNotAcceptLicenseCommand"){

            protected void onSelection() {
                SetupLicenseWizardPage.this.setEnabled(false);
            }
        };
        doNotAcceptCommand.setSelected(true);
        CommandGroup.createExclusiveCommandGroup(new ToggleCommand[]{acceptCommand, doNotAcceptCommand});
        GridBagLayoutBuilder formBuilder = new GridBagLayoutBuilder();
        formBuilder.append((Component)new JScrollPane(this.licenseTextPane), 1, 1, true, true);
        formBuilder.nextLine();
        formBuilder.append(acceptCommand.createRadioButton());
        formBuilder.nextLine();
        formBuilder.append(doNotAcceptCommand.createRadioButton());
        return formBuilder.getPanel();
    }

    protected void initLicenseTextPane() {
        this.licenseTextPane = new HtmlPane();
        this.updateLicenseTextPane();
    }

    private void updateLicenseTextPane() {
        try {
            Assert.state((this.licenseTextLocation != null ? 1 : 0) != 0, (String)"License text location is not set");
            String text = FileCopyUtils.copyToString((Reader)new BufferedReader(new InputStreamReader(this.licenseTextLocation.getInputStream())));
            this.licenseTextPane.setText(LabelUtils.htmlBlock(text));
        }
        catch (IOException e) {
            IllegalStateException exp = new IllegalStateException("License text not accessible: " + e.getMessage());
            exp.setStackTrace(e.getStackTrace());
            throw exp;
        }
    }
}

