/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.splash;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.richclient.application.splash.SplashScreen;
import org.springframework.richclient.components.ShadowBorderFrame;
import org.springframework.richclient.util.WindowUtils;

public abstract class AbstractSplashScreen
implements SplashScreen {
    public static final String SPLASH_TITLE_KEY = "splash.title";
    private JFrame frame;
    private MessageSource messageSource;
    private String iconResourcePath;
    private boolean shadowBorder;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private boolean rootFrame = true;

    public String getIconResourcePath() {
        return this.iconResourcePath;
    }

    public void setIconResourcePath(String iconResourcePath) {
        this.iconResourcePath = iconResourcePath;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public final void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
            this.frame = null;
        }
    }

    public final void splash() {
        JFrame jFrame = this.frame = this.shadowBorder ? new ShadowBorderFrame() : new JFrame();
        if (this.isRootFrame()) {
            JOptionPane.setRootFrame(this.frame);
        }
        this.frame.setDefaultCloseOperation(0);
        this.frame.setUndecorated(true);
        this.frame.setTitle(this.loadFrameTitle());
        this.frame.setIconImage(this.loadFrameIcon());
        Component content = this.createContentPane();
        if (content != null) {
            this.frame.getContentPane().add(content);
        }
        this.frame.pack();
        WindowUtils.centerOnScreen(this.frame);
        this.frame.setVisible(true);
    }

    private String loadFrameTitle() {
        try {
            return this.messageSource == null ? null : this.messageSource.getMessage(SPLASH_TITLE_KEY, null, null);
        }
        catch (NoSuchMessageException e) {
            return null;
        }
    }

    private Image loadFrameIcon() {
        if (this.iconResourcePath == null) {
            return null;
        }
        URL url = this.getClass().getResource(this.iconResourcePath);
        if (url == null) {
            this.logger.warn((Object)("Unable to locate splash screen in classpath at: " + this.iconResourcePath));
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    protected abstract Component createContentPane();

    public boolean isShadowBorder() {
        return this.shadowBorder;
    }

    public void setShadowBorder(boolean shadowBorder) {
        this.shadowBorder = shadowBorder;
    }

    public void setRootFrame(boolean rootFrame) {
        this.rootFrame = rootFrame;
    }

    public boolean isRootFrame() {
        return this.rootFrame;
    }
}

