/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.splash;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.springframework.richclient.application.splash.MonitoringSplashScreen;
import org.springframework.richclient.application.splash.SimpleSplashScreen;
import org.springframework.richclient.progress.ProgressBarProgressMonitor;
import org.springframework.richclient.progress.ProgressMonitor;
import org.springframework.util.Assert;

public class ProgressSplashScreen
extends SimpleSplashScreen
implements MonitoringSplashScreen {
    private JProgressBar progressBar;
    private boolean showProgressLabel;
    private ProgressMonitor progressMonitor;
    private boolean indeterminate = true;

    public boolean isShowProgressLabel() {
        return this.showProgressLabel;
    }

    public void setShowProgressLabel(boolean showProgressLabel) {
        this.showProgressLabel = showProgressLabel;
    }

    protected Component createContentPane() {
        JPanel content = new JPanel(new BorderLayout());
        Component component = super.createContentPane();
        if (component != null) {
            content.add(component);
        }
        JProgressBar progressBar = this.getProgressBar();
        progressBar.setIndeterminate(this.isIndeterminate());
        progressBar.setStringPainted(this.isShowProgressLabel());
        content.add((Component)progressBar, "South");
        return content;
    }

    public ProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressBarProgressMonitor(this.getProgressBar());
        }
        return this.progressMonitor;
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    protected JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = this.createProgressBar();
            Assert.notNull((Object)this.progressBar, (String)"createProgressBar should not return null");
        }
        return this.progressBar;
    }

    protected JProgressBar createProgressBar() {
        return new JProgressBar();
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
    }
}

