/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.splash;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.richclient.application.splash.AbstractSplashScreen;
import org.springframework.util.Assert;

public class SimpleSplashScreen
extends AbstractSplashScreen {
    private Image image;
    private Resource imageResourcePath;
    private static final Log logger = LogFactory.getLog(SimpleSplashScreen.class);

    public SimpleSplashScreen() {
    }

    public SimpleSplashScreen(Resource imageResourcePath) {
        this.setImageResourcePath(imageResourcePath);
    }

    public SimpleSplashScreen(Image image) {
        Assert.notNull((Object)image, (String)"The splash screen image is required");
        this.image = image;
    }

    public void setImageResourcePath(Resource path) {
        Assert.notNull((Object)path, (String)"The splash screen image resource path is required");
        this.imageResourcePath = path;
    }

    private Image loadImage(Resource path) throws IOException {
        URL url = path.getURL();
        if (url == null) {
            logger.warn((Object)("Unable to locate splash screen in classpath at: " + path));
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(url);
    }

    protected Image getImage() {
        if (this.image == null && this.imageResourcePath != null) {
            try {
                this.image = this.loadImage(this.imageResourcePath);
            }
            catch (IOException e) {
                logger.error((Object)("Unable to load image from resource " + this.imageResourcePath), (Throwable)e);
            }
        }
        return this.image;
    }

    protected Component createContentPane() {
        Image image = this.getImage();
        if (image != null) {
            return new ImageCanvas(image);
        }
        return null;
    }

    public class ImageCanvas
    extends JPanel {
        private static final long serialVersionUID = -5096223464173393949L;
        private Image image;

        public ImageCanvas(Image image) {
            this.image = image;
            this.loadImage();
            Dimension size = new Dimension(image.getWidth(null), image.getHeight(null));
            this.setSize(size);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
        }

        private void loadImage() {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Interrupted while waiting for splash image to load.", (Throwable)e);
            }
        }

        public void paintComponent(Graphics g) {
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.image, 0, 0, this);
        }
    }
}

