/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.statusbar.support;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.image.IconSource;
import org.springframework.richclient.progress.ProgressMonitor;
import org.springframework.util.StringUtils;

public class StatusBarProgressMonitor
extends AbstractControlFactory
implements ProgressMonitor {
    public static final int DEFAULT_DELAY_PROGRESS = 500;
    public static final int UNKNOWN = -1;
    private JButton cancelButton;
    private boolean cancelEnabled = true;
    private Icon cancelIcon;
    private JPanel control;
    private boolean isCanceled;
    private JProgressBar progressBar;
    private long startTime;
    private String taskName;
    private int delayProgress = 500;

    protected JButton createCancelButton() {
        JButton cancelButton = new JButton();
        cancelButton.setBorderPainted(false);
        cancelButton.setIcon(this.getCancelIcon());
        cancelButton.setMargin(new Insets(0, 0, 0, 0));
        return cancelButton;
    }

    protected JComponent createControl() {
        this.control = new JPanel(new BorderLayout());
        this.cancelButton = this.createCancelButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatusBarProgressMonitor.this.logger.info((Object)"Requesting task cancellation...");
                StatusBarProgressMonitor.this.setCanceled(true);
            }
        });
        this.progressBar = this.createProgressBar();
        this.control.add(this.progressBar);
        this.control.add((Component)this.cancelButton, "After");
        Border bevelBorder = BorderFactory.createBevelBorder(1, UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"));
        Border emptyBorder = BorderFactory.createEmptyBorder(1, 3, 1, 3);
        this.control.setBorder(BorderFactory.createCompoundBorder(bevelBorder, emptyBorder));
        this.hideProgress();
        return this.control;
    }

    protected JProgressBar createProgressBar() {
        JProgressBar progressBar = new JProgressBar();
        progressBar.setPreferredSize(new Dimension(200, 17));
        progressBar.setStringPainted(true);
        return progressBar;
    }

    public void done() {
        this.startTime = 0L;
        if (this.progressBar != null) {
            this.progressBar.setValue(this.progressBar.getMaximum());
            this.progressBar.setString("");
        }
        this.hideProgress();
    }

    public Icon getCancelIcon() {
        if (this.cancelIcon == null) {
            this.cancelIcon = ((IconSource)ApplicationServicesLocator.services().getService(IconSource.class)).getIcon("cancel.icon");
        }
        return this.cancelIcon;
    }

    protected JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private void hideButton() {
        this.cancelButton.setEnabled(this.cancelEnabled);
        this.cancelButton.setVisible(false);
    }

    protected void hideProgress() {
        if (this.progressBar.isVisible()) {
            this.progressBar.setVisible(false);
            this.cancelButton.setVisible(false);
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean b) {
        this.isCanceled = b;
        this.cancelButton.setEnabled(!b);
    }

    public void setCancelEnabled(boolean enabled) {
        this.cancelEnabled = enabled;
        if (this.progressBar.isVisible() && !this.cancelButton.isVisible() && enabled) {
            this.showButton();
        } else {
            this.hideButton();
        }
    }

    public void setCancelIcon(Icon icon) {
        this.cancelIcon = icon;
        if (this.cancelButton != null) {
            this.cancelButton.setIcon(icon);
        }
    }

    private void showButton() {
        this.cancelButton.setEnabled(this.cancelEnabled);
        this.cancelButton.setVisible(true);
    }

    private void showProgress() {
        if (!this.progressBar.isVisible()) {
            if (this.cancelEnabled) {
                this.showButton();
            }
            this.progressBar.setVisible(true);
        }
    }

    public void subTaskStarted(String name) {
        String text = name.length() == 0 ? name : (StringUtils.hasText((String)this.taskName) ? this.taskName + " - " + name : name);
        this.progressBar.setString(text);
    }

    public void taskStarted(String name, int totalWork) {
        this.startTime = System.currentTimeMillis();
        this.isCanceled = false;
        if (totalWork == -1) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMaximum(totalWork);
            this.progressBar.setValue(0);
        }
        this.taskName = name;
        this.progressBar.setString(this.taskName);
        this.showProgress();
    }

    public void worked(int work) {
        if (!this.progressBar.isVisible() && System.currentTimeMillis() - this.startTime > (long)this.delayProgress) {
            this.control.setVisible(true);
        }
        this.progressBar.setValue(work);
        if (this.progressBar.isStringPainted()) {
            this.progressBar.setString(work + "%");
        }
    }

    public void setDelayProgress(int delayProgress) {
        this.delayProgress = delayProgress;
    }
}

