/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.util.Collections;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PageComponent;
import org.springframework.richclient.application.View;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.config.CommandButtonLabelInfo;
import org.springframework.richclient.command.support.ShowViewCommand;
import org.springframework.richclient.core.LabeledObjectSupport;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultViewDescriptor
extends LabeledObjectSupport
implements ViewDescriptor,
BeanNameAware,
InitializingBean {
    private String id;
    private Class<? extends View> viewClass;
    private Map<String, Object> viewProperties;

    public DefaultViewDescriptor() {
    }

    public DefaultViewDescriptor(String id, Class<? extends View> viewClass) {
        this(id, viewClass, Collections.emptyMap());
    }

    public DefaultViewDescriptor(String id, Class<? extends View> viewClass, Map<String, Object> viewProperties) {
        this.setId(id);
        this.setViewClass(viewClass);
        this.setViewProperties(viewProperties);
    }

    public void setBeanName(String beanName) {
        this.setId(beanName);
    }

    public void setId(String id) {
        Assert.notNull((Object)"id is required");
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Class<? extends View> getViewClass() {
        return this.viewClass;
    }

    public void setViewClass(Class<? extends View> viewClass) {
        Assert.notNull(viewClass, (String)"viewClass cannot be null");
        Assert.isTrue((boolean)View.class.isAssignableFrom(viewClass), (String)"viewClass doesn't derive from View");
        this.viewClass = viewClass;
    }

    public void setViewProperties(Map<String, Object> viewProperties) {
        this.viewProperties = viewProperties;
    }

    @Override
    public PageComponent createPageComponent() {
        return this.createView();
    }

    protected View createView() {
        Assert.state((this.viewClass != null ? 1 : 0) != 0, (String)"View class to instantiate is not set");
        Object o = BeanUtils.instantiateClass(this.viewClass);
        Assert.isTrue((boolean)(o instanceof View), (String)("View class '" + this.viewClass + "' was instantiated, but instance is not a View!"));
        View view = (View)o;
        view.setDescriptor(this);
        if (this.viewProperties != null) {
            BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)view);
            wrapper.setPropertyValues(this.viewProperties);
        }
        if (view instanceof InitializingBean) {
            try {
                ((InitializingBean)view).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new BeanInitializationException("Problem running on " + view, (Throwable)e);
            }
        }
        return view;
    }

    @Override
    public CommandButtonLabelInfo getShowViewCommandLabel() {
        return this.getLabel();
    }

    @Override
    public ActionCommand createShowViewCommand(ApplicationWindow window) {
        return new ShowViewCommand(this, window);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.id, (String)"id is mandatory");
        Assert.notNull(this.viewClass, (String)"viewClass is mandatory");
    }
}

