/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.application.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.application.ViewDescriptorRegistry;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleViewDescriptorRegistry
implements ViewDescriptorRegistry {
    private Map<String, ViewDescriptor> descriptors = new HashMap<String, ViewDescriptor>();

    public SimpleViewDescriptorRegistry() {
    }

    public SimpleViewDescriptorRegistry(List<ViewDescriptor> descriptors) {
        Assert.notNull(descriptors, (String)"descriptors cannot be null");
        for (ViewDescriptor descriptor : descriptors) {
            this.addViewDescriptor(descriptor);
        }
    }

    public void addViewDescriptor(ViewDescriptor descriptor) {
        Assert.notNull((Object)descriptor, (String)"descriptor cannot be null");
        this.descriptors.put(descriptor.getId(), descriptor);
    }

    public void removeViewDescriptor(ViewDescriptor descriptor) {
        Assert.notNull((Object)descriptor, (String)"descriptor cannot be null");
        this.descriptors.remove(descriptor.getId());
    }

    @Override
    public ViewDescriptor getViewDescriptor(String viewDescriptorId) {
        Assert.hasText((String)viewDescriptorId, (String)"viewDescriptorId cannot be empty");
        return this.descriptors.get(viewDescriptorId);
    }

    @Override
    public ViewDescriptor[] getViewDescriptors() {
        return this.descriptors.values().toArray(new ViewDescriptor[this.descriptors.size()]);
    }
}

