/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.command.GroupContainerPopulator;
import org.springframework.richclient.command.GroupMember;
import org.springframework.richclient.command.config.CommandButtonConfigurer;

class GroupMemberContainerManager {
    private static final Log logger = LogFactory.getLog(GroupMemberContainerManager.class);
    private GroupContainerPopulator containerPopulator;
    private Object factory;
    private CommandButtonConfigurer configurer;

    public GroupMemberContainerManager(GroupContainerPopulator containerPopulator, Object factory, CommandButtonConfigurer configurer) {
        this.containerPopulator = containerPopulator;
        this.factory = factory;
        this.configurer = configurer;
    }

    public void setVisible(boolean visible) {
        this.containerPopulator.getContainer().setVisible(visible);
    }

    public void rebuildControlsFor(Collection members) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rebuilding group member controls; members=" + members));
        }
        Component[] components = this.containerPopulator.getContainer().getComponents();
        ArrayList<Component> previousButtons = new ArrayList<Component>(components.length);
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof AbstractButton)) continue;
            previousButtons.add(components[i]);
        }
        this.containerPopulator.getContainer().removeAll();
        for (GroupMember member : members) {
            member.fill(this.containerPopulator, this.factory, this.configurer, previousButtons);
        }
        this.containerPopulator.onPopulated();
        this.containerPopulator.getContainer().validate();
        this.containerPopulator.getContainer().repaint();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rebuild complete; container control count = " + this.containerPopulator.getContainer().getComponentCount()));
        }
    }
}

