/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.ActionCommandExecutor;
import org.springframework.richclient.command.ActionCommandInterceptor;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.CommandGroupFactoryBean;
import org.springframework.richclient.command.CommandManager;
import org.springframework.richclient.command.CommandNotOfRequiredTypeException;
import org.springframework.richclient.command.CommandRegistry;
import org.springframework.richclient.command.CommandRegistryListener;
import org.springframework.richclient.command.CommandServices;
import org.springframework.richclient.command.ExclusiveCommandGroup;
import org.springframework.richclient.command.TargetableActionCommand;
import org.springframework.richclient.command.config.CommandButtonConfigurer;
import org.springframework.richclient.command.config.CommandConfigurer;
import org.springframework.richclient.command.config.CommandFaceDescriptor;
import org.springframework.richclient.command.support.DefaultCommandRegistry;
import org.springframework.richclient.factory.ButtonFactory;
import org.springframework.richclient.factory.ComponentFactory;
import org.springframework.richclient.factory.MenuFactory;
import org.springframework.util.Assert;

public class DefaultCommandManager
implements CommandManager,
BeanPostProcessor,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private BeanFactory beanFactory;
    private final DefaultCommandRegistry commandRegistry = new DefaultCommandRegistry();
    private CommandServices commandServices;
    private CommandConfigurer commandConfigurer;

    public DefaultCommandManager() {
    }

    public DefaultCommandManager(CommandRegistry parent) {
        this.setParent(parent);
    }

    public DefaultCommandManager(CommandServices commandServices) {
        this.setCommandServices(commandServices);
    }

    public void setCommandServices(CommandServices commandServices) {
        Assert.notNull((Object)commandServices, (String)"A command services implementation is required");
        this.commandServices = commandServices;
    }

    public CommandServices getCommandServices() {
        if (this.commandServices == null) {
            this.commandServices = (CommandServices)ApplicationServicesLocator.services().getService(CommandServices.class);
        }
        return this.commandServices;
    }

    public void setParent(CommandRegistry parent) {
        this.commandRegistry.setParent(parent);
    }

    public CommandConfigurer getCommandConfigurer() {
        if (this.commandConfigurer == null) {
            this.commandConfigurer = (CommandConfigurer)ApplicationServicesLocator.services().getService(CommandConfigurer.class);
        }
        return this.commandConfigurer;
    }

    public void setCommandConfigurer(CommandConfigurer commandConfigurer) {
        Assert.notNull((Object)commandConfigurer, (String)"command configurer must not be null");
        this.commandConfigurer = commandConfigurer;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public ComponentFactory getComponentFactory() {
        return this.getCommandServices().getComponentFactory();
    }

    public ButtonFactory getToolBarButtonFactory() {
        return this.getCommandServices().getButtonFactory();
    }

    public ButtonFactory getButtonFactory() {
        return this.getCommandServices().getButtonFactory();
    }

    public MenuFactory getMenuFactory() {
        return this.getCommandServices().getMenuFactory();
    }

    public CommandButtonConfigurer getDefaultButtonConfigurer() {
        return this.getCommandServices().getDefaultButtonConfigurer();
    }

    public CommandButtonConfigurer getToolBarButtonConfigurer() {
        return this.getCommandServices().getToolBarButtonConfigurer();
    }

    public CommandButtonConfigurer getMenuItemButtonConfigurer() {
        return this.getCommandServices().getMenuItemButtonConfigurer();
    }

    public CommandButtonConfigurer getPullDownMenuButtonConfigurer() {
        return this.getCommandServices().getPullDownMenuButtonConfigurer();
    }

    public CommandFaceDescriptor getFaceDescriptor(AbstractCommand command, String faceDescriptorId) {
        if (this.beanFactory == null) {
            return null;
        }
        try {
            return (CommandFaceDescriptor)this.beanFactory.getBean(command.getId() + "." + faceDescriptorId, CommandFaceDescriptor.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            try {
                return (CommandFaceDescriptor)this.beanFactory.getBean(faceDescriptorId, CommandFaceDescriptor.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                return null;
            }
        }
    }

    public ActionCommand getActionCommand(String commandId) {
        return (ActionCommand)this.commandRegistry.getCommand(commandId, ActionCommand.class);
    }

    public CommandGroup getCommandGroup(String groupId) {
        return (CommandGroup)this.commandRegistry.getCommand(groupId, CommandGroup.class);
    }

    public boolean containsCommandGroup(String groupId) {
        return this.commandRegistry.containsCommandGroup(groupId);
    }

    public boolean containsActionCommand(String commandId) {
        return this.commandRegistry.containsActionCommand(commandId);
    }

    public void addCommandInterceptor(String commandId, ActionCommandInterceptor interceptor) {
        this.getActionCommand(commandId).addCommandInterceptor(interceptor);
    }

    public void removeCommandInterceptor(String commandId, ActionCommandInterceptor interceptor) {
        this.getActionCommand(commandId).removeCommandInterceptor(interceptor);
    }

    public void registerCommand(AbstractCommand command) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Configuring and registering new command '" + command.getId() + "'"));
        }
        this.configure(command);
        this.commandRegistry.registerCommand(command);
    }

    public void setTargetableActionCommandExecutor(String commandId, ActionCommandExecutor executor) {
        this.commandRegistry.setTargetableActionCommandExecutor(commandId, executor);
    }

    public void addCommandRegistryListener(CommandRegistryListener l) {
        this.commandRegistry.addCommandRegistryListener(l);
    }

    public void removeCommandRegistryListener(CommandRegistryListener l) {
        this.commandRegistry.removeCommandRegistryListener(l);
    }

    public TargetableActionCommand createTargetableActionCommand(String commandId, ActionCommandExecutor delegate) {
        Assert.notNull((Object)commandId, (String)"Registered targetable action commands must have an id.");
        TargetableActionCommand newCommand = new TargetableActionCommand(commandId, delegate);
        this.registerCommand(newCommand);
        return newCommand;
    }

    public CommandGroup createCommandGroup(String groupId, Object[] members) {
        Assert.notNull((Object)groupId, (String)"Registered command groups must have an id.");
        CommandGroup newGroup = new CommandGroupFactoryBean(groupId, this.commandRegistry, this, members).getCommandGroup();
        this.registerCommand(newGroup);
        return newGroup;
    }

    public ExclusiveCommandGroup createExclusiveCommandGroup(String groupId, Object[] members) {
        Assert.notNull((Object)groupId, (String)"Registered exclusive command groups must have an id.");
        CommandGroupFactoryBean newGroupFactory = new CommandGroupFactoryBean(groupId, this.commandRegistry, this, members);
        newGroupFactory.setExclusive(true);
        this.registerCommand(newGroupFactory.getCommandGroup());
        return (ExclusiveCommandGroup)newGroupFactory.getCommandGroup();
    }

    public AbstractCommand configure(AbstractCommand command) {
        return this.getCommandConfigurer().configure(command);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractCommand) {
            this.registerCommand((AbstractCommand)bean);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof CommandGroupFactoryBean) {
            CommandGroupFactoryBean factory = (CommandGroupFactoryBean)bean;
            factory.setCommandRegistry(this.commandRegistry);
        } else if (bean instanceof AbstractCommand) {
            this.configure((AbstractCommand)bean);
        }
        return bean;
    }

    public boolean containsCommand(String commandId) {
        return this.commandRegistry.containsCommand(commandId);
    }

    public Object getCommand(String commandId, Class requiredType) throws CommandNotOfRequiredTypeException {
        return this.commandRegistry.getCommand(commandId, requiredType);
    }

    public Object getCommand(String commandId) {
        return this.commandRegistry.getCommand(commandId);
    }

    public Class getType(String commandId) {
        return this.commandRegistry.getType(commandId);
    }

    public boolean isTypeMatch(String commandId, Class targetType) {
        return this.commandRegistry.isTypeMatch(commandId, targetType);
    }
}

