/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.support;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.command.AbstractCommand;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.ActionCommandExecutor;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.command.CommandNotOfRequiredTypeException;
import org.springframework.richclient.command.CommandRegistry;
import org.springframework.richclient.command.CommandRegistryEvent;
import org.springframework.richclient.command.CommandRegistryListener;
import org.springframework.richclient.command.TargetableActionCommand;
import org.springframework.richclient.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DefaultCommandRegistry
implements CommandRegistry,
CommandRegistryListener {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final List commandRegistryListeners = new LinkedList();
    private final Map commandMap = new Hashtable();
    private CommandRegistry parent;

    public DefaultCommandRegistry() {
    }

    public DefaultCommandRegistry(CommandRegistry parent) {
        this.internalSetParent(parent);
    }

    public void setParent(CommandRegistry parent) {
        this.internalSetParent(parent);
    }

    private void internalSetParent(CommandRegistry parentRegistry) {
        if (!ObjectUtils.nullSafeEquals((Object)this.parent, (Object)parentRegistry)) {
            if (this.parent != null) {
                this.parent.removeCommandRegistryListener(this);
            }
            this.parent = parentRegistry;
            if (this.parent != null) {
                this.parent.addCommandRegistryListener(this);
            }
        }
    }

    public void commandRegistered(CommandRegistryEvent event) {
        Assert.required(event, "event");
        this.fireCommandRegistered(event.getCommand());
    }

    public ActionCommand getActionCommand(String commandId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to retrieve ActionCommand with id [" + commandId + "] from the command registry."));
        }
        Object command = this.getCommand(commandId, ActionCommand.class);
        return (ActionCommand)command;
    }

    public CommandGroup getCommandGroup(String groupId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempting to retrieve command group with id [" + groupId + "] from the command registry."));
        }
        Object command = this.getCommand(groupId, CommandGroup.class);
        return (CommandGroup)command;
    }

    public boolean containsActionCommand(String commandId) {
        if (this.commandMap.containsKey(commandId)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsActionCommand(commandId);
        }
        return false;
    }

    public boolean containsCommandGroup(String groupId) {
        if (this.commandMap.get(groupId) instanceof CommandGroup) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsCommandGroup(groupId);
        }
        return false;
    }

    public void registerCommand(AbstractCommand command) {
        Assert.notNull((Object)command, (String)"Command cannot be null.");
        Assert.isTrue((command.getId() != null ? 1 : 0) != 0, (String)"A command must have an identifier to be placed in a registry.");
        AbstractCommand previousCommand = this.commandMap.put(command.getId(), command);
        if (previousCommand != null && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The command [" + previousCommand + "] was overwritten in the registry with the command [" + command + "]"));
        }
        if (command instanceof CommandGroup) {
            ((CommandGroup)command).setCommandRegistry(this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Command registered '" + command.getId() + "'"));
        }
        this.fireCommandRegistered(command);
    }

    protected void fireCommandRegistered(AbstractCommand command) {
        Assert.required(command, "command");
        if (this.commandRegistryListeners.isEmpty()) {
            return;
        }
        CommandRegistryEvent event = new CommandRegistryEvent(this, command);
        Iterator i = this.commandRegistryListeners.iterator();
        while (i.hasNext()) {
            ((CommandRegistryListener)i.next()).commandRegistered(event);
        }
    }

    public void setTargetableActionCommandExecutor(String commandId, ActionCommandExecutor executor) {
        Assert.required(commandId, "commandId");
        TargetableActionCommand command = (TargetableActionCommand)this.getCommand(commandId, TargetableActionCommand.class);
        if (command != null) {
            command.setCommandExecutor(executor);
        }
    }

    public void addCommandRegistryListener(CommandRegistryListener listener) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding command registry listener " + listener));
        }
        this.commandRegistryListeners.add(listener);
    }

    public void removeCommandRegistryListener(CommandRegistryListener listener) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing command registry listener " + listener));
        }
        this.commandRegistryListeners.remove(listener);
    }

    public CommandRegistry getParent() {
        return this.parent;
    }

    public boolean containsCommand(String commandId) {
        Assert.required(commandId, "commandId");
        if (this.commandMap.containsKey(commandId)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsCommand(commandId);
        }
        return false;
    }

    public Object getCommand(String commandId) {
        return this.getCommand(commandId, null);
    }

    public Object getCommand(String commandId, Class requiredType) throws CommandNotOfRequiredTypeException {
        Assert.required(commandId, "commandId");
        Object command = this.commandMap.get(commandId);
        if (command == null && this.parent != null) {
            command = this.parent.getCommand(commandId);
        }
        if (command == null) {
            return null;
        }
        if (requiredType != null && !ClassUtils.isAssignableValue((Class)requiredType, command)) {
            throw new CommandNotOfRequiredTypeException(commandId, requiredType, command.getClass());
        }
        return command;
    }

    public Class getType(String commandId) {
        Assert.required(commandId, "commandId");
        Object command = this.getCommand(commandId);
        if (command == null) {
            return null;
        }
        return command.getClass();
    }

    public boolean isTypeMatch(String commandId, Class targetType) {
        Assert.required(commandId, "commandId");
        Assert.required(targetType, "targetType");
        Class commandType = this.getType(commandId);
        if (commandType == null) {
            return false;
        }
        return ClassUtils.isAssignable((Class)targetType, (Class)commandType);
    }
}

