/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.command.support;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.application.PropertyNotSetException;
import org.springframework.richclient.application.ViewDescriptor;
import org.springframework.richclient.command.support.ApplicationWindowAwareCommand;
import org.springframework.richclient.util.Assert;

public class ShowViewCommand
extends ApplicationWindowAwareCommand
implements InitializingBean {
    private ViewDescriptor viewDescriptor;

    public ShowViewCommand() {
    }

    public ShowViewCommand(ViewDescriptor viewDescriptor, ApplicationWindow applicationWindow) {
        Assert.required(applicationWindow, "applicationWindow");
        this.setViewDescriptor(viewDescriptor);
        this.setApplicationWindow(applicationWindow);
        this.setEnabled(true);
    }

    public void afterPropertiesSet() {
        PropertyNotSetException.throwIfNull(this.getApplicationWindow(), "applicationWindow", this.getClass());
        PropertyNotSetException.throwIfNull(this.viewDescriptor, "viewDescriptor", this.getClass());
    }

    public final void setViewDescriptor(ViewDescriptor viewDescriptor) {
        Assert.required(viewDescriptor, "viewDescriptor");
        this.setId(viewDescriptor.getId());
        this.setLabel(viewDescriptor.getShowViewCommandLabel());
        this.setIcon(viewDescriptor.getIcon());
        this.setCaption(viewDescriptor.getCaption());
        this.viewDescriptor = viewDescriptor;
    }

    protected void doExecuteCommand() {
        this.getApplicationWindow().getPage().showView(this.viewDescriptor.getId());
    }
}

