/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.components;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class FileChooser
extends JComponent {
    private JTextField nameField;
    private JButton openDialogButton;
    private int openDialogButtonWidth = 20;
    private FileChooserMode mode = FileChooserMode.FILE;

    public FileChooser() {
        this.nameField = new JTextField();
        Handler handler = new Handler();
        this.openDialogButton = new JButton("...");
        this.openDialogButton.setName("openDialogButton");
        this.openDialogButton.setRolloverEnabled(false);
        this.openDialogButton.setFocusable(false);
        this.openDialogButton.addMouseListener(handler);
        this.add(this.nameField);
        this.add(this.openDialogButton);
    }

    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        this.nameField.setBounds(insets.left, insets.bottom, width - 3 - this.openDialogButtonWidth, height);
        this.openDialogButton.setBounds(width - this.openDialogButtonWidth + insets.left, insets.bottom, this.openDialogButtonWidth, height);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dim = this.nameField.getPreferredSize();
        dim.width += this.openDialogButton.getPreferredSize().width;
        Insets insets = this.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return dim;
    }

    public void setMode(FileChooserMode mode) {
        this.mode = mode;
    }

    public FileChooserMode getMode() {
        return this.mode;
    }

    public void setText(String text) {
        this.nameField.setText(text);
    }

    public String getText() {
        return this.nameField.getText();
    }

    public void setEditable(boolean editable) {
        if (editable) {
            this.nameField.setEditable(true);
            this.openDialogButton.setEnabled(true);
        } else {
            this.nameField.setEditable(false);
            this.openDialogButton.setEnabled(false);
        }
    }

    public boolean isEditable() {
        return this.nameField.isEditable();
    }

    public void setEnabled(boolean enabled) {
        this.nameField.setEnabled(enabled);
        this.openDialogButton.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.nameField.isEnabled() & this.openDialogButton.isEnabled();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileChooserMode {
        FILE,
        FOLDER;

    }

    private class Handler
    extends MouseAdapter {
        private Handler() {
        }

        public void mousePressed(MouseEvent ev) {
            if (FileChooser.this.isEnabled()) {
                JFileChooser chooser = new JFileChooser();
                switch (FileChooser.this.mode) {
                    case FILE: {
                        chooser.setFileSelectionMode(0);
                        break;
                    }
                    case FOLDER: {
                        chooser.setFileSelectionMode(1);
                    }
                }
                int result = chooser.showOpenDialog(null);
                if (result == 1) {
                    return;
                }
                FileChooser.this.nameField.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

