/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.components;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JFrame;

public class ShadowBorderFrame
extends JFrame {
    private BufferedImage backgroundImage;
    private static final int SHADOW_WIDTH = 14;

    public void paint(Graphics g) {
        g.drawImage(this.backgroundImage, 0, 0, this);
        super.paint(g);
    }

    public void show() {
        this.createShadowBorder();
        super.show();
        this.setSize(this.getWidth() + 14, this.getHeight() + 14);
    }

    private void createShadowBorder() {
        this.backgroundImage = new BufferedImage(this.getWidth() + 14, this.getHeight() + 14, 2);
        Graphics2D g2 = (Graphics2D)this.backgroundImage.getGraphics();
        try {
            Robot robot = new Robot(this.getGraphicsConfiguration().getDevice());
            BufferedImage capture = robot.createScreenCapture(new Rectangle(this.getX(), this.getY(), this.getWidth() + 14, this.getHeight() + 14));
            g2.drawImage(capture, null, 0, 0);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        BufferedImage shadow = new BufferedImage(this.getWidth() + 14, this.getHeight() + 14, 2);
        Graphics graphics = shadow.getGraphics();
        graphics.setColor(new Color(0.0f, 0.0f, 0.0f, 0.3f));
        graphics.fillRoundRect(6, 6, this.getWidth(), this.getHeight(), 12, 12);
        g2.drawImage(shadow, this.getBlurOp(7), 0, 0);
    }

    private ConvolveOp getBlurOp(int size) {
        float[] data = new float[size * size];
        float value = 1.0f / (float)(size * size);
        for (int i = 0; i < data.length; ++i) {
            data[i] = value;
        }
        return new ConvolveOp(new Kernel(size, size, data));
    }
}

