/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.components;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.form.binding.swing.text.TimeFormatter;

public class TimeTextField
extends JFormattedTextField {
    Log log = LogFactory.getLog(TimeTextField.class);
    private static final String INPUT_SEPARATORS = "[hHuU\\s\\.,+*-/]";

    public TimeTextField() {
        super(new TimeFormatter());
        this.setDocument(new TimeDocument());
        this.setFocusLostBehavior(1);
        this.addFocusListener(new UpdateFocusListener());
    }

    private void updateText(String txt) {
        try {
            this.getDocument().remove(0, this.getText().length());
            this.getDocument().insertString(0, txt, null);
        }
        catch (BadLocationException e) {
            this.log.error((Object)"Text out of boundaries. ", (Throwable)e);
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1004) {
            this.setCaretPosition(0);
            this.moveCaretPosition(this.getDocument().getLength());
        }
    }

    class TimeDocument
    extends PlainDocument {
        TimeDocument() {
        }

        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            this.remove(offset, length);
            this.insertString(offset, text, attrs);
        }

        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
        }

        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if ((str = this.isValidString(offset, str)) != null) {
                super.insertString(offset, str, a);
            }
        }

        private String isValidString(int offset, String str) throws BadLocationException {
            int length;
            if (str == null) {
                return null;
            }
            str = str.replaceAll(TimeTextField.INPUT_SEPARATORS, ":");
            String s = this.getText(0, offset) + str;
            if (offset < this.getLength()) {
                s = s + this.getText(offset, this.getLength() - offset);
            }
            char[] strArray = s.toCharArray();
            int sepPos = -1;
            for (int i = 0; i < strArray.length; ++i) {
                if (Character.isDigit(strArray[i])) continue;
                if (':' != strArray[i] || sepPos != -1) {
                    return null;
                }
                sepPos = i;
                if (sepPos <= 2 && this.getLength() - sepPos <= 2) continue;
                return null;
            }
            int n = length = sepPos == -1 ? s.length() : s.length() - 1;
            if (length > 4) {
                return null;
            }
            return str;
        }
    }

    class UpdateFocusListener
    implements FocusListener {
        UpdateFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            try {
                TimeTextField.this.commitEdit();
                String valueToString = TimeTextField.this.getFormatter().valueToString(TimeTextField.this.getValue());
                TimeTextField.this.updateText(valueToString);
            }
            catch (Exception e1) {
                TimeTextField.this.log.error((Object)"Invalid date format. ", (Throwable)e1);
            }
        }
    }
}

