/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.convert.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.binding.convert.ConversionContext;
import org.springframework.binding.convert.Converter;
import org.springframework.binding.convert.support.AbstractConverter;
import org.springframework.core.ReflectiveVisitorHelper;

public class CollectionConverter
extends AbstractConverter
implements Converter {
    private static final Class[] SOURCE_CLASSES = new Class[]{Object.class, Collection.class, List.class, Object[].class};
    private static final Class[] TARGET_CLASSES = new Class[]{Collection.class, List.class, Object[].class};
    private final ReflectiveVisitorHelper visitorHelper = new ReflectiveVisitorHelper();
    private Object visitor = new ValuesVisitor();

    protected Object doConvert(Object sourceValue, Class targetClass, ConversionContext context) throws Exception {
        List values = (List)this.visitorHelper.invokeVisit(this.visitor, sourceValue);
        if (Object[].class == targetClass) {
            return values.toArray();
        }
        return values;
    }

    public Class[] getSourceClasses() {
        return SOURCE_CLASSES;
    }

    public Class[] getTargetClasses() {
        return TARGET_CLASSES;
    }

    protected static class ValuesVisitor {
        protected ValuesVisitor() {
        }

        List visitNull() {
            return Collections.EMPTY_LIST;
        }

        List visit(Object value) {
            return this.visit(new Object[]{value});
        }

        List visit(Collection values) {
            return new ArrayList(values);
        }

        List visit(List values) {
            return values;
        }

        List visit(Object[] values) {
            return Arrays.asList(values);
        }
    }
}

