/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.core;

import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.Severity;
import org.springframework.richclient.image.IconSource;
import org.springframework.richclient.image.NoSuchImageResourceException;
import org.springframework.richclient.util.LabelUtils;
import org.springframework.util.ObjectUtils;

public class DefaultMessage
implements Message,
Serializable {
    private static final long serialVersionUID = -6524078363891514995L;
    private final long timestamp;
    private final String message;
    private final Severity severity;
    public static final DefaultMessage EMPTY_MESSAGE = new DefaultMessage("", null);

    public DefaultMessage(String text) {
        this(text, Severity.INFO);
    }

    public DefaultMessage(String message, Severity severity) {
        if (message == null) {
            message = "";
        }
        this.timestamp = System.currentTimeMillis();
        this.message = message;
        this.severity = severity;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void renderMessage(JComponent component) {
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setText(this.getMessage());
        } else if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            label.setText(LabelUtils.htmlBlock(this.getMessage()));
            label.setIcon(this.getIcon());
        } else {
            throw new IllegalArgumentException("Unsupported component type " + component);
        }
    }

    public Icon getIcon() {
        if (this.severity == null) {
            return null;
        }
        try {
            IconSource iconSource = (IconSource)ApplicationServicesLocator.services().getService(IconSource.class);
            return iconSource.getIcon("severity." + this.severity.getLabel());
        }
        catch (NoSuchImageResourceException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof DefaultMessage)) {
            return false;
        }
        DefaultMessage other = (DefaultMessage)o;
        return this.message.equals(other.message) && ObjectUtils.nullSafeEquals((Object)((Object)this.severity), (Object)((Object)other.severity));
    }

    public int hashCode() {
        return this.message.hashCode() + (this.severity != null ? this.severity.hashCode() : 0);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("message", (Object)this.message).append("severity", (Object)this.severity).toString();
    }
}

