/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.core;

import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.richclient.util.Assert;
import org.springframework.util.StringUtils;

public final class LabelInfo {
    private static final Log logger = LogFactory.getLog(LabelInfo.class);
    private static final LabelInfo BLANK_LABEL_INFO = new LabelInfo("");
    private static final int DEFAULT_MNEMONIC = 0;
    private static final int DEFAULT_MNEMONIC_INDEX = -1;
    private final String text;
    private final int mnemonic;
    private final int mnemonicIndex;

    public static LabelInfo valueOf(String labelDescriptor) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating a new LabelInfo from label descriptor [" + labelDescriptor + "]"));
        }
        if (!StringUtils.hasText((String)labelDescriptor)) {
            return BLANK_LABEL_INFO;
        }
        StringBuffer labelText = new StringBuffer();
        char mnemonicChar = '\u0000';
        int mnemonicCharIndex = -1;
        int i = 0;
        while (i < labelDescriptor.length()) {
            char currentChar = labelDescriptor.charAt(i);
            int nextCharIndex = i + 1;
            if (currentChar == '\\') {
                LabelInfo.checkForValidEscapedCharacter(nextCharIndex, labelDescriptor);
                labelText.append(labelDescriptor.charAt(nextCharIndex));
                ++i;
                ++i;
                continue;
            }
            if (currentChar == '&') {
                if (mnemonicChar != '\u0000') {
                    throw new IllegalArgumentException("The label descriptor [" + labelDescriptor + "] can only contain one non-escaped ampersand.");
                }
                if (nextCharIndex >= labelDescriptor.length()) {
                    throw new IllegalArgumentException("The label descriptor [" + labelDescriptor + "] cannot have a non-escaped ampersand as its last character.");
                }
                mnemonicChar = labelDescriptor.charAt(nextCharIndex);
                LabelInfo.checkForValidMnemonicChar(mnemonicChar, labelDescriptor);
                labelText.append(mnemonicChar);
                mnemonicCharIndex = labelText.length() - 1;
                ++i;
                ++i;
                continue;
            }
            labelText.append(currentChar);
            ++i;
        }
        return new LabelInfo(labelText.toString(), Character.toUpperCase(mnemonicChar), mnemonicCharIndex);
    }

    private static void checkForValidEscapedCharacter(int index, String labelDescriptor) {
        if (index >= labelDescriptor.length()) {
            throw new IllegalArgumentException("The label descriptor contains an invalid escape sequence. Backslash characters (\\) must be followed by either an ampersand (&) or another backslash.");
        }
        char escapedChar = labelDescriptor.charAt(index);
        if (escapedChar != '&' && escapedChar != '\\') {
            throw new IllegalArgumentException("The label descriptor [" + labelDescriptor + "] contains an invalid escape sequence. Backslash " + "characters (\\) must be followed by either an ampersand (&) or another " + "backslash.");
        }
    }

    private static void checkForValidMnemonicChar(char mnemonicChar, String labelDescriptor) {
        if (mnemonicChar == ' ') {
            throw new IllegalArgumentException("The mnemonic character cannot be a space. [" + labelDescriptor + "]");
        }
    }

    public LabelInfo(String text) {
        this(text, 0, -1);
    }

    public LabelInfo(String text, int mnemonic) {
        this(text, mnemonic, -1);
    }

    public LabelInfo(String text, int mnemonic, int mnemonicIndex) {
        Assert.required(text, "text");
        Assert.isTrue((mnemonic >= 0 ? 1 : 0) != 0, (String)"mnemonic must be greater than or equal to 0");
        Assert.isTrue((mnemonicIndex >= -1 ? 1 : 0) != 0, (String)"mnemonicIndex must be greater than or equal to -1");
        Assert.isTrue((mnemonicIndex < text.length() ? 1 : 0) != 0, (String)("The mnemonic index must be less than the text length; mnemonicIndex = " + mnemonicIndex + ", text length = " + text.length()));
        this.text = text;
        if (!StringUtils.hasText((String)text)) {
            mnemonicIndex = -1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Constructing a new LabelInfo instance with properties: text='" + text + "', mnemonic=" + mnemonic + ", mnemonicIndex=" + mnemonicIndex));
        }
        this.mnemonic = mnemonic;
        this.mnemonicIndex = mnemonicIndex;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.mnemonic;
        result = 31 * result + this.mnemonicIndex;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelInfo other = (LabelInfo)obj;
        if (this.mnemonic != other.mnemonic) {
            return false;
        }
        if (this.mnemonicIndex != other.mnemonicIndex) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public void configureLabel(JLabel label) {
        Assert.required(label, "label");
        label.setText(this.text);
        label.setDisplayedMnemonic(this.getMnemonic());
        if (this.getMnemonicIndex() >= -1) {
            label.setDisplayedMnemonicIndex(this.getMnemonicIndex());
        }
    }

    public void configureLabelFor(JLabel label, JComponent component) {
        String labelText;
        Assert.required(label, "label");
        Assert.required(component, "component");
        this.configureLabel(label);
        if (!(component instanceof JPanel) && !(labelText = label.getText()).endsWith(":")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Appending colon to text field label text '" + this.text + "'"));
            }
            label.setText(labelText + ":");
        }
        label.setLabelFor(component);
    }

    public void configureButton(AbstractButton button) {
        Assert.notNull((Object)button);
        button.setText(this.text);
        button.setMnemonic(this.getMnemonic());
        button.setDisplayedMnemonicIndex(this.getMnemonicIndex());
    }

    public String getText() {
        return this.text;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public int getMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("text", (Object)this.text).append("mnemonic", this.mnemonic).append("mnemonicIndex", this.mnemonicIndex).toString();
    }
}

