/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.DefaultMessageAreaModel;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.dialog.MessagePane;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.image.EmptyIcon;
import org.springframework.util.StringUtils;

public class DefaultMessageAreaPane
extends AbstractControlFactory
implements MessagePane,
PropertyChangeListener {
    private static final int ONE_LINE_IN_DLU = 10;
    public static final int DEFAULT_LINES_TO_DISPLAY = 2;
    private int linesToDisplay;
    private JLabel messageLabel;
    private Icon defaultIcon = EmptyIcon.SMALL;
    private DefaultMessageAreaModel messageAreaModel;

    public DefaultMessageAreaPane() {
        this(2);
    }

    public DefaultMessageAreaPane(int linesToDisplay) {
        this.init(linesToDisplay, this);
    }

    public DefaultMessageAreaPane(Messagable delegateFor) {
        this(2, delegateFor);
    }

    public DefaultMessageAreaPane(int linesToDisplay, Messagable delegateFor) {
        this.init(linesToDisplay, delegateFor);
    }

    private void init(int linesToDisplay, Messagable delegateFor) {
        this.linesToDisplay = linesToDisplay;
        this.messageAreaModel = new DefaultMessageAreaModel(delegateFor);
        this.messageAreaModel.addPropertyChangeListener(this);
    }

    public void setDefaultIcon(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    protected JComponent createControl() {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel();
            this.messageAreaModel.renderMessage(this.messageLabel);
        }
        int prefWidth = this.messageLabel.getPreferredSize().width;
        int prefHeight = Sizes.dialogUnitYAsPixel((int)(this.linesToDisplay * 10), (Component)this.messageLabel);
        int iconHeight = this.getDefaultIcon().getIconHeight() + this.messageLabel.getIconTextGap() * 2;
        prefHeight = Math.max(iconHeight, prefHeight);
        this.messageLabel.setPreferredSize(new Dimension(prefWidth, prefHeight));
        this.messageLabel.setOpaque(false);
        this.messageLabel.setVerticalAlignment(1);
        this.messageLabel.setVerticalTextPosition(1);
        this.messageLabel.setIcon(this.getDefaultIcon());
        return this.messageLabel;
    }

    private Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    public Message getMessage() {
        return this.messageAreaModel.getMessage();
    }

    public void setMessage(Message message) {
        this.messageAreaModel.setMessage(message);
        if (this.messageLabel != null) {
            this.messageAreaModel.renderMessage(this.messageLabel);
        }
    }

    public void clearMessage() {
        this.messageAreaModel.setMessage(null);
    }

    public boolean isMessageShowing() {
        if (this.messageLabel == null) {
            return false;
        }
        return StringUtils.hasText((String)this.messageLabel.getText()) && this.messageLabel.isVisible();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.messageAreaModel.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.messageAreaModel.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.messageAreaModel.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.messageAreaModel.removePropertyChangeListener(propertyName, listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel();
        }
        this.messageAreaModel.getMessage().renderMessage(this.messageLabel);
    }
}

