/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import com.jgoodies.forms.factories.FormFactory;
import java.awt.Color;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.core.TitleConfigurable;
import org.springframework.richclient.dialog.DefaultMessageAreaPane;
import org.springframework.richclient.dialog.MessagePane;
import org.springframework.richclient.factory.AbstractControlFactory;
import org.springframework.richclient.image.config.ImageConfigurable;
import org.springframework.richclient.layout.TableLayoutBuilder;

public class TitlePane
extends AbstractControlFactory
implements MessagePane,
TitleConfigurable,
ImageConfigurable {
    public static final String DEFAULT_TITLE_IMAGE = "titledDialog.image";
    private String title = "Title Pane Title";
    private Image image;
    private JLabel titleLabel;
    private JLabel iconLabel;
    private MessagePane messagePane;

    public TitlePane() {
        this(2);
    }

    public TitlePane(int linesToDisplay) {
        this.messagePane = new DefaultMessageAreaPane(linesToDisplay, this);
    }

    public void setTitle(String newTitle) {
        if (newTitle == null) {
            newTitle = "";
        }
        this.title = newTitle;
        if (this.isControlCreated()) {
            this.titleLabel.setText(newTitle);
        }
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.isControlCreated()) {
            this.iconLabel.setIcon(this.getIcon());
        }
    }

    protected JComponent createControl() {
        this.titleLabel = new JLabel();
        this.titleLabel.setName("title");
        this.titleLabel.setOpaque(false);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.titleLabel.setText(this.title);
        this.iconLabel = new JLabel();
        this.iconLabel.setName("icon");
        this.iconLabel.setBackground(this.getBackgroundColor());
        this.iconLabel.setIcon(this.getIcon());
        JPanel panel = new JPanel();
        panel.setName("panel");
        panel.setBackground(this.getBackgroundColor());
        TableLayoutBuilder table = new TableLayoutBuilder(panel);
        table.row(FormFactory.LINE_GAP_ROWSPEC);
        table.gapCol();
        table.cell(this.titleLabel);
        table.gapCol();
        table.cell(this.iconLabel, "rowspan=2 colspec=pref");
        table.row(FormFactory.NARROW_LINE_GAP_ROWSPEC);
        table.cell(this.messagePane.getControl());
        table.row(FormFactory.NARROW_LINE_GAP_ROWSPEC);
        return table.getPanel();
    }

    private Icon getIcon() {
        if (this.image != null) {
            return new ImageIcon(this.image);
        }
        return new ImageIcon(this.getImageSource().getImage(DEFAULT_TITLE_IMAGE));
    }

    private Color getBackgroundColor() {
        Color c = UIManager.getLookAndFeel().getDefaults().getColor("primaryControlHighlight");
        if (c == null) {
            c = UIManager.getColor("controlLtHighlight");
        }
        return c;
    }

    public boolean isMessageShowing() {
        return this.messagePane.isMessageShowing();
    }

    public Message getMessage() {
        return this.messagePane.getMessage();
    }

    public void setMessage(Message newMessage) {
        this.messagePane.setMessage(newMessage);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.messagePane.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.messagePane.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.messagePane.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.messagePane.removePropertyChangeListener(propertyName, listener);
    }

    public String getTitle() {
        return this.title;
    }

    public Image getImage() {
        return this.image;
    }
}

