/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog;

import java.awt.Image;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.springframework.richclient.core.DefaultMessage;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.CloseAction;
import org.springframework.richclient.dialog.DialogPage;
import org.springframework.richclient.dialog.FormBackedDialogPage;
import org.springframework.richclient.dialog.TitledApplicationDialog;
import org.springframework.richclient.form.Form;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class TitledPageApplicationDialog
extends TitledApplicationDialog {
    private DialogPage dialogPage;
    private PropertyChangeListener dialogPagePropertyChangeHandler = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("message".equals(evt.getPropertyName())) {
                TitledPageApplicationDialog.this.update();
            } else if ("pageComplete".equals(evt.getPropertyName())) {
                TitledPageApplicationDialog.this.setEnabled(TitledPageApplicationDialog.this.dialogPage.isPageComplete());
            } else {
                TitledPageApplicationDialog.this.update();
            }
        }
    };
    private Image titlePaneImage;
    private String titlePaneTitle;

    public TitledPageApplicationDialog() {
    }

    public TitledPageApplicationDialog(DialogPage dialogPage) {
        this.setDialogPage(dialogPage);
    }

    public TitledPageApplicationDialog(Form form, Window parent) {
        this(new FormBackedDialogPage(form), parent);
    }

    public TitledPageApplicationDialog(DialogPage dialogPage, Window parent) {
        super(dialogPage.getTitle(), parent);
        this.setDialogPage(dialogPage);
    }

    public TitledPageApplicationDialog(DialogPage dialogPage, Window parent, CloseAction closeAction) {
        super(dialogPage.getTitle(), parent, closeAction);
        this.setDialogPage(dialogPage);
    }

    protected void setDialogPage(DialogPage dialogPage) {
        Assert.notNull((Object)dialogPage, (String)"The single dialog page to display is required");
        this.dialogPage = dialogPage;
    }

    protected DialogPage getDialogPage() {
        return this.dialogPage;
    }

    protected JComponent createTitledDialogContentPane() {
        this.dialogPage.addPropertyChangeListener(this.dialogPagePropertyChangeHandler);
        this.update();
        return this.dialogPage.getControl();
    }

    protected Message getDescription() {
        return new DefaultMessage(this.dialogPage.getDescription());
    }

    protected void update() {
        if (!StringUtils.hasText((String)this.getTitle())) {
            this.setTitle(this.dialogPage.getTitle());
        }
        this.updateTitlePane();
        this.updateMessagePane();
    }

    protected void updateTitlePane() {
        super.setTitlePaneTitle(this.titlePaneTitle != null ? this.titlePaneTitle : this.dialogPage.getTitle());
        super.setTitlePaneImage(this.titlePaneImage != null ? this.titlePaneImage : this.dialogPage.getImage());
        this.setDescription(this.dialogPage.getDescription());
    }

    protected void updateMessagePane() {
        this.setMessage(this.dialogPage.getMessage());
    }

    public void setTitlePaneImage(Image image) {
        this.titlePaneImage = image;
        super.setTitlePaneImage(image);
    }

    public void setTitlePaneTitle(String title) {
        this.titlePaneTitle = title;
        super.setTitlePaneTitle(title);
    }
}

