/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog.control;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.Icon;
import javax.swing.JComponent;

public class Tab {
    public static final String TITLE_PROPERTY = "title";
    public static final String ICON_PROPERTY = "icon";
    public static final String TOOLTIP_PROPERTY = "tooltip";
    public static final String COMPONENT_PROPERTY = "component";
    public static final String VISIBLE_PROPERTY = "visible";
    public static final String MNEMONIC_PROPERTY = "mnemonic";
    public static final String ENABLED_PROPERTY = "enabled";
    private String title;
    private Icon icon;
    private String tooltip;
    private JComponent component;
    private boolean visible = true;
    private int mnemonic;
    private boolean enabled = true;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public Tab(String title, JComponent component) {
        this.title = title;
        this.component = component;
    }

    public Tab() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean old = this.visible;
        this.visible = visible;
        if (old != visible) {
            this.propertyChangeSupport.firePropertyChange(VISIBLE_PROPERTY, old, visible);
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void setComponent(JComponent component) {
        JComponent old = this.component;
        this.component = component;
        if (old != component) {
            this.propertyChangeSupport.firePropertyChange(COMPONENT_PROPERTY, old, component);
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        Icon old = this.icon;
        this.icon = icon;
        if (old != icon) {
            this.propertyChangeSupport.firePropertyChange(ICON_PROPERTY, old, icon);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String old = this.title;
        this.title = title;
        if (old != null && !old.equals(title) || title != null) {
            this.propertyChangeSupport.firePropertyChange(TITLE_PROPERTY, old, title);
        }
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        String old = this.tooltip;
        this.tooltip = tooltip;
        if (old != null && !old.equals(tooltip) || tooltip != null) {
            this.propertyChangeSupport.firePropertyChange(TOOLTIP_PROPERTY, old, tooltip);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, l);
    }

    public void setMnemonic(int mnemonic) {
        int old = this.mnemonic;
        this.mnemonic = mnemonic;
        if (mnemonic != old) {
            this.propertyChangeSupport.firePropertyChange(MNEMONIC_PROPERTY, old, mnemonic);
        }
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean old = this.enabled;
        this.enabled = enabled;
        if (enabled != old) {
            this.propertyChangeSupport.firePropertyChange(ENABLED_PROPERTY, old, enabled);
        }
    }
}

