/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.dialog.support;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.springframework.richclient.command.ActionCommand;
import org.springframework.richclient.command.CommandGroup;
import org.springframework.richclient.core.Guarded;
import org.springframework.richclient.core.Message;
import org.springframework.richclient.dialog.DialogPage;
import org.springframework.richclient.dialog.Messagable;
import org.springframework.richclient.dialog.TitlePane;
import org.springframework.richclient.util.GuiStandardUtils;

public class DialogPageUtils {
    public static TitlePane createTitlePane(DialogPage dialogPage) {
        TitlePane titlePane = new TitlePane();
        titlePane.setTitle(dialogPage.getTitle());
        titlePane.setImage(dialogPage.getImage());
        DialogPageUtils.addMessageMonitor(dialogPage, titlePane);
        return titlePane;
    }

    public static JComponent createStandardView(DialogPage dialogPage, ActionCommand okCommand, ActionCommand cancelCommand) {
        DialogPageUtils.adaptPageCompletetoGuarded(dialogPage, okCommand);
        return DialogPageUtils.createStandardView(dialogPage, new Object[]{okCommand, cancelCommand});
    }

    public static JComponent createStandardView(DialogPage dialogPage, Object[] commandGroupMembers) {
        JPanel viewPanel = new JPanel(new BorderLayout());
        JPanel titlePaneContainer = new JPanel(new BorderLayout());
        titlePaneContainer.add(DialogPageUtils.createTitlePane(dialogPage).getControl());
        titlePaneContainer.add((Component)new JSeparator(), "South");
        viewPanel.add((Component)titlePaneContainer, "North");
        JComponent pageControl = dialogPage.getControl();
        GuiStandardUtils.attachDialogBorder(pageControl);
        viewPanel.add(pageControl);
        viewPanel.add((Component)DialogPageUtils.createButtonBar(commandGroupMembers), "South");
        return viewPanel;
    }

    public static JComponent createButtonBar(Object[] groupMembers) {
        CommandGroup dialogCommandGroup = CommandGroup.createCommandGroup(null, groupMembers);
        JComponent buttonBar = dialogCommandGroup.createButtonBar();
        GuiStandardUtils.attachDialogBorder(buttonBar);
        return buttonBar;
    }

    public static void addMessageMonitor(DialogPage dialogPage, Messagable monitor) {
        dialogPage.addPropertyChangeListener("message", new MessageHandler(monitor));
    }

    public static void adaptPageCompletetoGuarded(DialogPage dialogPage, Guarded guarded) {
        dialogPage.addPropertyChangeListener("pageComplete", new PageCompleteAdapter(guarded));
    }

    private static class MessageHandler
    implements PropertyChangeListener {
        private Messagable monitor;

        public MessageHandler(Messagable monitor) {
            this.monitor = monitor;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("message".equals(e.getPropertyName())) {
                this.monitor.setMessage((Message)e.getNewValue());
            }
        }
    }

    protected static class PageCompleteAdapter
    implements PropertyChangeListener {
        private Guarded guarded;

        protected PageCompleteAdapter(Guarded guarded) {
            this.guarded = guarded;
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("pageComplete".equals(e.getPropertyName())) {
                this.guarded.setEnabled((Boolean)e.getNewValue());
            }
        }
    }
}

