/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.richclient.application.Application;
import org.springframework.richclient.application.ApplicationServicesLocator;
import org.springframework.richclient.application.ApplicationWindow;
import org.springframework.richclient.exceptionhandling.AbstractLoggingExceptionHandler;
import org.springframework.richclient.exceptionhandling.ShutdownPolicy;

public abstract class AbstractDialogExceptionHandler
extends AbstractLoggingExceptionHandler
implements InitializingBean {
    private static final String DIALOG_EXCEPTION_HANDLER_KEY = "dialogExceptionHandler";
    protected MessageSourceAccessor messageSourceAccessor;
    protected boolean modalDialog = true;
    protected ShutdownPolicy shutdownPolicy = ShutdownPolicy.ASK;

    public void setMessageSourceAccessor(MessageSourceAccessor messageSourceAccessor) {
        this.messageSourceAccessor = messageSourceAccessor;
    }

    public void setModalDialog(boolean modalDialog) {
        this.modalDialog = modalDialog;
    }

    public void setShutdownPolicy(ShutdownPolicy shutdownPolicy) {
        this.shutdownPolicy = shutdownPolicy;
    }

    public void afterPropertiesSet() {
        if (this.messageSourceAccessor == null) {
            this.messageSourceAccessor = (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUserAboutException(Thread thread, Throwable throwable) {
        Object[] options;
        switch (this.shutdownPolicy) {
            case NONE: {
                options = new String[]{this.messageSourceAccessor.getMessage("dialogExceptionHandler.none.ok")};
                break;
            }
            case ASK: {
                options = new String[]{this.messageSourceAccessor.getMessage("dialogExceptionHandler.ask.shutdown"), this.messageSourceAccessor.getMessage("dialogExceptionHandler.ask.continue")};
                break;
            }
            case OBLIGATE: {
                options = new String[]{this.messageSourceAccessor.getMessage("dialogExceptionHandler.obligate.shutdown")};
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized shutdownPolicy: " + (Object)((Object)this.shutdownPolicy));
            }
        }
        int result = JOptionPane.showOptionDialog(this.resolveParentFrame(), this.createExceptionContent(throwable), this.resolveExceptionCaption(throwable), -1, this.resolveMessageType(), null, options, options[0]);
        if (this.shutdownPolicy == ShutdownPolicy.ASK && result == 0 || this.shutdownPolicy == ShutdownPolicy.OBLIGATE) {
            this.logger.info((Object)"Shutting down due to uncaught exception.");
            try {
                if (Application.isLoaded()) {
                    Application.instance().close(true, 1);
                }
            }
            finally {
                System.exit(2);
            }
        }
    }

    protected JFrame resolveParentFrame() {
        ApplicationWindow activeWindow = Application.isLoaded() ? Application.instance().getActiveWindow() : null;
        return activeWindow == null ? null : activeWindow.getControl();
    }

    public abstract Object createExceptionContent(Throwable var1);

    public abstract String resolveExceptionCaption(Throwable var1);

    private int resolveMessageType() {
        switch (this.logLevel) {
            case TRACE: 
            case DEBUG: 
            case INFO: {
                return 1;
            }
            case WARN: {
                return 2;
            }
        }
        return 0;
    }
}

