/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.richclient.exceptionhandling.AbstractRegisterableExceptionHandler;
import org.springframework.richclient.exceptionhandling.LogLevel;
import org.springframework.richclient.exceptionhandling.delegation.ExceptionPurger;

public abstract class AbstractLoggingExceptionHandler
extends AbstractRegisterableExceptionHandler {
    protected static final String LOG_MESSAGE = "Uncaught throwable handled";
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected LogLevel logLevel = LogLevel.ERROR;
    protected ExceptionPurger exceptionPurger = null;

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setExceptionPurger(ExceptionPurger exceptionPurger) {
        this.exceptionPurger = exceptionPurger;
    }

    public final void uncaughtException(Thread thread, Throwable throwable) {
        try {
            if (this.exceptionPurger != null) {
                throwable = this.exceptionPurger.purge(throwable);
            }
            this.logException(thread, throwable);
            this.notifyUserAboutException(thread, throwable);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void logException(Thread thread, Throwable throwable) {
        switch (this.logLevel) {
            case TRACE: {
                this.logger.trace((Object)LOG_MESSAGE, throwable);
                break;
            }
            case DEBUG: {
                this.logger.debug((Object)LOG_MESSAGE, throwable);
                break;
            }
            case INFO: {
                this.logger.info((Object)LOG_MESSAGE, throwable);
                break;
            }
            case WARN: {
                this.logger.warn((Object)LOG_MESSAGE, throwable);
                break;
            }
            case ERROR: {
                this.logger.error((Object)LOG_MESSAGE, throwable);
                break;
            }
            case FATAL: {
                this.logger.fatal((Object)LOG_MESSAGE, throwable);
                break;
            }
            default: {
                this.logger.error((Object)("Unrecognized log level (" + (Object)((Object)this.logLevel) + ") for throwable"), throwable);
            }
        }
    }

    public abstract void notifyUserAboutException(Thread var1, Throwable var2);
}

