/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.jdic.desktop.Desktop;
import org.jdesktop.jdic.desktop.DesktopException;
import org.jdesktop.jdic.desktop.Message;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.richclient.application.ApplicationServicesLocator;

public class EmailNotifierErrorReporter
implements ErrorReporter,
BeanNameAware,
InitializingBean {
    private MessageSourceAccessor messageSourceAccessor;
    private String id;

    public void afterPropertiesSet() {
        if (this.messageSourceAccessor == null) {
            this.messageSourceAccessor = (MessageSourceAccessor)ApplicationServicesLocator.services().getService(MessageSourceAccessor.class);
        }
        if (this.getId() == null) {
            this.setId(StringUtils.uncapitalize((String)this.getClass().getSimpleName()));
        }
    }

    public void reportError(ErrorInfo info) throws NullPointerException {
        Message mail = new Message();
        Object[] params = new Object[]{info.getBasicErrorMessage(), info.getDetailedErrorMessage()};
        if (info.getErrorException() != null) {
            params = new Object[]{info.getErrorException(), this.getStackTraceString(info.getErrorException())};
        }
        String body = this.messageSourceAccessor.getMessage(this.getId() + ".body", params, "");
        String title = this.messageSourceAccessor.getMessage(this.getId() + ".title", "");
        String adresses = this.messageSourceAccessor.getMessage(this.getId() + ".mailTo", "");
        if (!StringUtils.isEmpty((String)adresses)) {
            mail.setToAddrs(Arrays.asList(adresses.split(";")));
        }
        mail.setSubject(title);
        mail.setBody(body);
        try {
            Desktop.mail((Message)mail);
        }
        catch (DesktopException e) {
            String mailExceptionMessage = this.messageSourceAccessor.getMessage(this.getId() + ".mailException", "");
            throw new RuntimeException(mailExceptionMessage, e);
        }
    }

    protected String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setBeanName(String name) {
        if (this.getId() == null) {
            this.setId(name);
        }
    }
}

