/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.ErrorCoded;
import org.springframework.richclient.exceptionhandling.AbstractDialogExceptionHandler;

public class MessagesDialogExceptionHandler
extends AbstractDialogExceptionHandler {
    private int wrapLength = 120;
    private int identLength = 2;
    private String messagesKey = null;

    public void setWrapLength(int wrapLength) {
        this.wrapLength = wrapLength;
    }

    public void setIdentLength(int identLength) {
        this.identLength = identLength;
    }

    public void setMessagesKey(String messagesKey) {
        this.messagesKey = messagesKey;
    }

    public String resolveExceptionCaption(Throwable throwable) {
        String[] messagesKeys = this.getMessagesKeys(throwable, ".caption");
        return this.messageSourceAccessor.getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(messagesKeys, messagesKeys[0]));
    }

    public Object createExceptionContent(Throwable throwable) {
        String[] messagesKeys = this.getMessagesKeys(throwable, ".description");
        Object[] parameters = new String[]{this.formatMessage(throwable.getMessage())};
        return this.messageSourceAccessor.getMessage((MessageSourceResolvable)new DefaultMessageSourceResolvable(messagesKeys, parameters, messagesKeys[0]));
    }

    private String[] getMessagesKeys(Throwable throwable, String keySuffix) {
        if (this.messagesKey != null) {
            return new String[]{this.messagesKey};
        }
        ArrayList<String> messageKeyList = new ArrayList<String>();
        Class<?> clazz = throwable.getClass();
        if (throwable instanceof ErrorCoded) {
            messageKeyList.add(((ErrorCoded)throwable).getErrorCode() + keySuffix);
        }
        if (throwable instanceof SQLException) {
            messageKeyList.add(SQLException.class.getName() + "." + ((SQLException)throwable).getErrorCode() + keySuffix);
        }
        while (clazz != Object.class) {
            messageKeyList.add(clazz.getName() + keySuffix);
            clazz = clazz.getSuperclass();
        }
        return messageKeyList.toArray(new String[messageKeyList.size()]);
    }

    protected String formatMessage(String message) {
        if (message == null) {
            return "";
        }
        String identString = StringUtils.leftPad((String)"", (int)this.identLength);
        String newLineWithIdentString = "\n" + identString;
        StringBuilder formattedMessageBuilder = new StringBuilder(identString);
        StringTokenizer messageTokenizer = new StringTokenizer(message, "\n");
        while (messageTokenizer.hasMoreTokens()) {
            String messageToken = messageTokenizer.nextToken();
            formattedMessageBuilder.append(WordUtils.wrap((String)messageToken, (int)this.wrapLength, (String)newLineWithIdentString, (boolean)true));
            if (!messageTokenizer.hasMoreTokens()) continue;
            formattedMessageBuilder.append(newLineWithIdentString);
        }
        return formattedMessageBuilder.toString();
    }
}

