/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling.delegation;

import java.util.Iterator;
import java.util.List;
import org.springframework.richclient.exceptionhandling.delegation.AbstractExceptionHandlerDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainInspectingExceptionHandlerDelegate
extends AbstractExceptionHandlerDelegate {
    private List<ChainPart> chainPartList;

    public ChainInspectingExceptionHandlerDelegate() {
    }

    public ChainInspectingExceptionHandlerDelegate(List<ChainPart> chainPartList, Thread.UncaughtExceptionHandler exceptionHandler) {
        super(exceptionHandler);
        this.chainPartList = chainPartList;
    }

    public void setChainPartList(List<ChainPart> chainPartList) {
        this.chainPartList = chainPartList;
    }

    @Override
    public boolean hasAppropriateHandlerPurged(Throwable root) {
        Throwable e = root;
        boolean check = true;
        Iterator<ChainPart> it = this.chainPartList.iterator();
        while (check && it.hasNext()) {
            ChainPart chainPart = it.next();
            e = this.findChainPartThrowable(chainPart, e);
            if (e == null) {
                check = false;
                continue;
            }
            if ((e = e.getCause() == e ? null : e.getCause()) != null) continue;
            check = check && !it.hasNext();
        }
        return check;
    }

    public Throwable findChainPartThrowable(ChainPart chainPart, Throwable firstThrowable) {
        Throwable e = firstThrowable;
        int minimumRelativeDepth = chainPart.getMinimumRelativeDepth();
        int maximumRelativeDepth = chainPart.getMaximumRelativeDepth();
        for (int relativeDepth = 0; !chainPart.getThrowableClass().isInstance(e) || relativeDepth < minimumRelativeDepth; ++relativeDepth) {
            Throwable cause = e.getCause();
            if (cause == null || cause == e) {
                return null;
            }
            e = cause;
            if (maximumRelativeDepth < 0 || relativeDepth <= maximumRelativeDepth) continue;
            return null;
        }
        return e;
    }

    @Override
    public void uncaughtExceptionPurged(Thread thread, Throwable throwable) {
        this.exceptionHandler.uncaughtException(thread, throwable);
    }

    public static class ChainPart {
        private Class throwableClass = Throwable.class;
        private int minimumRelativeDepth = 0;
        private int maximumRelativeDepth = -1;

        public ChainPart() {
        }

        public ChainPart(Class throwableClass) {
            this.throwableClass = throwableClass;
        }

        public ChainPart(Class throwableClass, int relativeDepth) {
            this(throwableClass, relativeDepth, relativeDepth);
        }

        public ChainPart(Class throwableClass, int minimumRelativeDepth, int maximumRelativeDepth) {
            this.throwableClass = throwableClass;
            this.minimumRelativeDepth = minimumRelativeDepth;
            this.maximumRelativeDepth = maximumRelativeDepth;
        }

        public Class getThrowableClass() {
            return this.throwableClass;
        }

        public void setThrowableClass(Class throwableClass) {
            this.throwableClass = throwableClass;
        }

        public void setRelativeDepth(int relativeDepth) {
            this.setMinimumRelativeDepth(relativeDepth);
            this.setMaximumRelativeDepth(relativeDepth);
        }

        public int getMinimumRelativeDepth() {
            return this.minimumRelativeDepth;
        }

        public void setMinimumRelativeDepth(int minimumRelativeDepth) {
            this.minimumRelativeDepth = minimumRelativeDepth;
        }

        public int getMaximumRelativeDepth() {
            return this.maximumRelativeDepth;
        }

        public void setMaximumRelativeDepth(int maximumRelativeDepth) {
            this.maximumRelativeDepth = maximumRelativeDepth;
        }
    }
}

