/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling.delegation;

import java.util.Collections;
import java.util.List;
import org.springframework.richclient.exceptionhandling.delegation.ExceptionPurger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExceptionPurger
implements ExceptionPurger {
    protected List<Class> includeThrowableClassList = Collections.emptyList();
    protected List<Class> excludeThrowableClassList = Collections.emptyList();

    public DefaultExceptionPurger() {
    }

    public DefaultExceptionPurger(Class includeThrowableClass, Class excludeThrowableClass) {
        if (includeThrowableClass != null) {
            this.includeThrowableClassList = Collections.singletonList(includeThrowableClass);
        }
        if (excludeThrowableClass != null) {
            this.excludeThrowableClassList = Collections.singletonList(excludeThrowableClass);
        }
    }

    public DefaultExceptionPurger(List<Class> includeThrowableClassList, List<Class> excludeThrowableClassList) {
        if (includeThrowableClassList != null) {
            this.includeThrowableClassList = includeThrowableClassList;
        }
        if (excludeThrowableClassList != null) {
            this.excludeThrowableClassList = excludeThrowableClassList;
        }
    }

    public void setIncludeThrowableClass(Class includeThrowableClass) {
        this.setIncludeThrowableClassList(Collections.singletonList(includeThrowableClass));
    }

    public void setIncludeThrowableClassList(List<Class> includeThrowableClassList) {
        this.includeThrowableClassList = includeThrowableClassList;
    }

    public void setExcludeThrowableClass(Class excludeThrowableClass) {
        this.setExcludeThrowableClassList(Collections.singletonList(excludeThrowableClass));
    }

    public void setExcludeThrowableClassList(List<Class> excludeThrowableClassList) {
        this.excludeThrowableClassList = excludeThrowableClassList;
    }

    @Override
    public Throwable purge(Throwable root) {
        Throwable excludedPurged = root;
        Throwable e = root;
        while (e != null) {
            if (this.containedIn(e, this.includeThrowableClassList)) {
                return e;
            }
            boolean excludedContained = this.containedIn(e, this.excludeThrowableClassList);
            if (excludedContained) {
                excludedPurged = e;
            }
            Throwable throwable = e = e.getCause() == e ? null : e.getCause();
            if (!excludedContained || e == null) continue;
            excludedPurged = e;
        }
        return excludedPurged;
    }

    protected boolean containedIn(Throwable e, List<Class> throwableClassList) {
        for (Class throwableClass : throwableClassList) {
            if (!throwableClass.isInstance(e)) continue;
            return true;
        }
        return false;
    }
}

