/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling.delegation;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.richclient.exceptionhandling.AbstractRegisterableExceptionHandler;
import org.springframework.richclient.exceptionhandling.delegation.ExceptionHandlerDelegate;
import org.springframework.richclient.exceptionhandling.delegation.ExceptionPurger;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingExceptionHandler
extends AbstractRegisterableExceptionHandler
implements InitializingBean {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected List<ExceptionHandlerDelegate> delegateList;
    protected ExceptionPurger exceptionPurger = null;

    public void setDelegateList(List<ExceptionHandlerDelegate> delegateList) {
        this.delegateList = delegateList;
    }

    public void setExceptionPurger(ExceptionPurger exceptionPurger) {
        this.exceptionPurger = exceptionPurger;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty(this.delegateList, (String)"The delegate list must contains at least one entry.");
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.exceptionPurger != null) {
            throwable = this.exceptionPurger.purge(throwable);
        }
        for (ExceptionHandlerDelegate delegate : this.delegateList) {
            if (!delegate.hasAppropriateHandler(throwable)) continue;
            delegate.uncaughtException(thread, throwable);
            return;
        }
        this.logger.error((Object)"No exception handler found for throwable", throwable);
    }
}

