/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.richclient.exceptionhandling.delegation;

import java.util.Collections;
import java.util.List;
import org.springframework.richclient.exceptionhandling.delegation.AbstractExceptionHandlerDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleExceptionHandlerDelegate
extends AbstractExceptionHandlerDelegate {
    private List<Class> throwableClassList;

    public SimpleExceptionHandlerDelegate() {
    }

    public SimpleExceptionHandlerDelegate(Class throwableClass, Thread.UncaughtExceptionHandler exceptionHandler) {
        this(Collections.singletonList(throwableClass), exceptionHandler);
    }

    public SimpleExceptionHandlerDelegate(List<Class> throwableClassList, Thread.UncaughtExceptionHandler exceptionHandler) {
        super(exceptionHandler);
        this.throwableClassList = throwableClassList;
    }

    public void setThrowableClass(Class throwableClass) {
        this.setThrowableClassList(Collections.singletonList(throwableClass));
    }

    public void setThrowableClassList(List<Class> throwableClassList) {
        this.throwableClassList = throwableClassList;
    }

    @Override
    public boolean hasAppropriateHandlerPurged(Throwable throwable) {
        for (Class throwableClass : this.throwableClassList) {
            if (!throwableClass.isInstance(throwable)) continue;
            return true;
        }
        return false;
    }
}

